/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.token.delegation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

@InterfaceStability.Evolving
public class TokenInformation {
    private final KafkaPrincipal owner;
    private final KafkaPrincipal tokenRequester;
    private final Collection<KafkaPrincipal> renewers;
    private final long issueTimestamp;
    private final long maxTimestamp;
    private long expiryTimestamp;
    private final String tokenId;

    public TokenInformation(String tokenId, KafkaPrincipal owner, Collection<KafkaPrincipal> renewers, long issueTimestamp, long maxTimestamp, long expiryTimestamp) {
        this(tokenId, owner, owner, renewers, issueTimestamp, maxTimestamp, expiryTimestamp);
    }

    public TokenInformation(String tokenId, KafkaPrincipal owner, KafkaPrincipal tokenRequester, Collection<KafkaPrincipal> renewers, long issueTimestamp, long maxTimestamp, long expiryTimestamp) {
        this.tokenId = tokenId;
        this.owner = owner;
        this.tokenRequester = tokenRequester;
        this.renewers = renewers;
        this.issueTimestamp = issueTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.expiryTimestamp = expiryTimestamp;
    }

    public KafkaPrincipal owner() {
        return this.owner;
    }

    public KafkaPrincipal tokenRequester() {
        return this.tokenRequester;
    }

    public String ownerAsString() {
        return this.owner.toString();
    }

    public Collection<KafkaPrincipal> renewers() {
        return this.renewers;
    }

    public Collection<String> renewersAsString() {
        ArrayList<String> renewerList = new ArrayList<String>();
        for (KafkaPrincipal renewer : this.renewers) {
            renewerList.add(renewer.toString());
        }
        return renewerList;
    }

    public long issueTimestamp() {
        return this.issueTimestamp;
    }

    public long expiryTimestamp() {
        return this.expiryTimestamp;
    }

    public void setExpiryTimestamp(long expiryTimestamp) {
        this.expiryTimestamp = expiryTimestamp;
    }

    public String tokenId() {
        return this.tokenId;
    }

    public long maxTimestamp() {
        return this.maxTimestamp;
    }

    public boolean ownerOrRenewer(KafkaPrincipal principal) {
        return this.owner.equals(principal) || this.tokenRequester.equals(principal) || this.renewers.contains(principal);
    }

    public String toString() {
        return "TokenInformation{owner=" + this.owner + ", tokenRequester=" + this.tokenRequester + ", renewers=" + this.renewers + ", issueTimestamp=" + this.issueTimestamp + ", maxTimestamp=" + this.maxTimestamp + ", expiryTimestamp=" + this.expiryTimestamp + ", tokenId='" + this.tokenId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenInformation that = (TokenInformation)o;
        return this.issueTimestamp == that.issueTimestamp && this.maxTimestamp == that.maxTimestamp && Objects.equals(this.owner, that.owner) && Objects.equals(this.tokenRequester, that.tokenRequester) && Objects.equals(this.renewers, that.renewers) && Objects.equals(this.tokenId, that.tokenId);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.tokenRequester, this.renewers, this.issueTimestamp, this.maxTimestamp, this.expiryTimestamp, this.tokenId);
    }
}

