/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import io.debezium.connector.cassandra.AbstractCommitLogProcessorTest;
import io.debezium.connector.cassandra.EOFEvent;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.Record;
import io.debezium.connector.cassandra.TestUtils;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.junit.Assert;

public class RowInsertionCommitLogProcessingTest
extends AbstractCommitLogProcessorTest {
    @Override
    public void initialiseData() throws Exception {
        this.createTable("CREATE TABLE IF NOT EXISTS %s.%s (a int, b int, PRIMARY KEY(a)) WITH cdc = true;");
        for (int i = 0; i < 10; ++i) {
            TestUtils.runCql((SimpleStatement)QueryBuilder.insertInto((String)"test_keyspace", (String)TestUtils.TEST_TABLE_NAME).value("a", (Term)QueryBuilder.literal((Object)i)).value("b", (Term)QueryBuilder.literal((Object)i)).build());
        }
    }

    @Override
    public void verifyEvents() throws Exception {
        for (Event event : this.getEvents()) {
            if (event instanceof Record) {
                Record record = (Record)event;
                Assert.assertEquals((Object)record.getEventType(), (Object)Event.EventType.CHANGE_EVENT);
                Assert.assertEquals((Object)record.getSource().cluster, (Object)DatabaseDescriptor.getClusterName());
                Assert.assertFalse((boolean)record.getSource().snapshot);
                Assert.assertEquals((Object)record.getSource().keyspaceTable.name(), (Object)TestUtils.keyspaceTable((String)TestUtils.TEST_TABLE_NAME));
                continue;
            }
            if (event instanceof EOFEvent) {
                EOFEvent eofEvent = (EOFEvent)event;
                Assert.assertFalse((boolean)this.context.getErroneousCommitLogs().contains(eofEvent.file.getName()));
                continue;
            }
            throw new Exception("unexpected event type");
        }
    }
}

