/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import io.debezium.connector.cassandra.AbstractCommitLogProcessorTest;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.Record;
import io.debezium.connector.cassandra.TestUtils;
import java.util.List;
import org.junit.Assert;

public class PartitionKeyRowDeletionCommitLogProcessingTest
extends AbstractCommitLogProcessorTest {
    @Override
    public void initialiseData() throws Exception {
        this.createTable("CREATE TABLE IF NOT EXISTS %s.%s (a int, b int, PRIMARY KEY(a)) WITH cdc = true;");
        TestUtils.runCql((SimpleStatement)QueryBuilder.insertInto((String)"test_keyspace", (String)TestUtils.TEST_TABLE_NAME).value("a", (Term)QueryBuilder.literal((Object)1)).value("b", (Term)QueryBuilder.literal((Object)1)).build());
        TestUtils.runCql((SimpleStatement)((Delete)QueryBuilder.deleteFrom((String)"test_keyspace", (String)TestUtils.TEST_TABLE_NAME).whereColumn("a").isEqualTo((Term)QueryBuilder.literal((Object)1))).build());
    }

    @Override
    public void verifyEvents() throws Exception {
        List<Event> events = this.getEvents();
        Record insert = (Record)events.get(0);
        Assert.assertEquals((Object)insert.getEventType(), (Object)Event.EventType.CHANGE_EVENT);
        Assert.assertEquals((Object)Record.Operation.INSERT, (Object)insert.getOp());
        Record delete = (Record)events.get(1);
        Assert.assertEquals((Object)delete.getEventType(), (Object)Event.EventType.CHANGE_EVENT);
        Assert.assertEquals((Object)Record.Operation.DELETE, (Object)delete.getOp());
    }
}

