/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.CellData;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.KeyValueSchema;
import io.debezium.connector.cassandra.RowData;
import io.debezium.connector.cassandra.SourceInfo;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public abstract class Record
implements Event {
    static final String AFTER = "after";
    static final String OPERATION = "op";
    static final String SOURCE = "source";
    static final String TIMESTAMP = "ts_ms";
    private final SourceInfo source;
    private final RowData rowData;
    private final Operation op;
    private final long ts;
    private final Schema keySchema;
    private final Schema valueSchema;
    private final boolean shouldMarkOffset;

    Record(SourceInfo source, RowData rowData, Schema keySchema, Schema valueSchema, Operation op, boolean shouldMarkOffset, long ts) {
        this.source = source;
        this.rowData = rowData;
        this.op = op;
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.shouldMarkOffset = shouldMarkOffset;
        this.ts = ts;
    }

    public Struct buildKey() {
        if (this.keySchema == null) {
            return null;
        }
        List<CellData> primary = this.rowData.getPrimary();
        Struct struct = new Struct(this.keySchema);
        for (CellData cellData : primary) {
            struct.put(cellData.name, cellData.value);
        }
        return struct;
    }

    public Struct buildValue() {
        if (this.valueSchema == null) {
            return null;
        }
        return new Struct(this.valueSchema).put(TIMESTAMP, (Object)this.ts).put(OPERATION, (Object)this.op.getValue()).put(SOURCE, (Object)this.source.struct()).put(AFTER, (Object)this.rowData.record(KeyValueSchema.getFieldSchema(AFTER, this.valueSchema)));
    }

    public String toString() {
        return "Record{source=" + this.source + ", after=" + this.rowData + ", keySchema=" + this.keySchema + ", valueSchema=" + this.valueSchema + ", op=" + this.op + ", ts=" + this.ts + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Record record = (Record)o;
        return this.ts == record.ts && Objects.equals((Object)this.source, (Object)record.source) && Objects.equals(this.rowData, record.rowData) && Objects.equals(this.keySchema, record.keySchema) && Objects.equals(this.valueSchema, record.valueSchema) && this.op == record.op;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.rowData, this.keySchema, this.valueSchema, this.op, this.ts});
    }

    public SourceInfo getSource() {
        return this.source;
    }

    public RowData getRowData() {
        return this.rowData;
    }

    public Operation getOp() {
        return this.op;
    }

    public long getTs() {
        return this.ts;
    }

    public Schema getKeySchema() {
        return this.keySchema;
    }

    public Schema getValueSchema() {
        return this.valueSchema;
    }

    public boolean shouldMarkOffset() {
        return this.shouldMarkOffset;
    }

    public static enum Operation {
        INSERT("i"),
        UPDATE("u"),
        DELETE("d");

        private String value;

        private Operation(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

