/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import io.debezium.DebeziumException;
import io.debezium.connector.cassandra.KafkaRecord;
import io.debezium.connector.cassandra.transforms.CassandraTypeConverter;
import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import java.util.Objects;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;

public class CellData
implements KafkaRecord {
    public static final String CELL_VALUE_KEY = "value";
    public static final String CELL_DELETION_TS_KEY = "deletion_ts";
    public static final String CELL_SET_KEY = "set";
    public final String name;
    public final Object value;
    public final Object deletionTs;
    public final ColumnType columnType;

    public CellData(String name, Object value, Object deletionTs, ColumnType columnType) {
        this.name = name;
        this.value = value;
        this.deletionTs = deletionTs;
        this.columnType = columnType;
    }

    public boolean isPrimary() {
        return this.columnType == ColumnType.PARTITION || this.columnType == ColumnType.CLUSTERING;
    }

    @Override
    public Struct record(Schema schema) {
        try {
            Struct cellStruct = new Struct(schema).put(CELL_DELETION_TS_KEY, this.deletionTs).put(CELL_SET_KEY, (Object)true).put(CELL_VALUE_KEY, this.value);
            return cellStruct;
        }
        catch (DataException e) {
            throw new DebeziumException(String.format("Failed to record Cell. Name: %s, Schema: %s, Value: %s", this.name, schema.toString(), this.value), (Throwable)e);
        }
    }

    static Schema cellSchema(ColumnMetadata cm, boolean optional) {
        AbstractType<?> convertedType = CassandraTypeConverter.convert(cm.getType());
        Schema valueSchema = CassandraTypeDeserializer.getSchemaBuilder(convertedType).build();
        if (valueSchema != null) {
            SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(cm.getName().toString()).field(CELL_VALUE_KEY, valueSchema).field(CELL_DELETION_TS_KEY, Schema.OPTIONAL_INT64_SCHEMA).field(CELL_SET_KEY, Schema.BOOLEAN_SCHEMA);
            if (optional) {
                schemaBuilder.optional();
            }
            return schemaBuilder.build();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellData that = (CellData)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && this.deletionTs == that.deletionTs && this.columnType == that.columnType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.value, this.deletionTs, this.columnType});
    }

    public String toString() {
        return "{name=" + this.name + ", value=" + this.value + ", deletionTs=" + this.deletionTs + ", type=" + this.columnType.name() + '}';
    }

    public static enum ColumnType {
        PARTITION,
        CLUSTERING,
        REGULAR;

    }
}

