/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog.util;

import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.connector.binlog.util.UniqueDatabaseProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import java.util.ServiceLoader;

public class TestHelper {
    public static UniqueDatabase getUniqueDatabase(String serverName, String databaseName) {
        try {
            UniqueDatabaseProvider provider = TestHelper.getUniqueDatabaseProvider();
            return provider.getUniqueDatabase().getConstructor(String.class, String.class).newInstance(serverName, databaseName);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create UniqueDatabase instance", e);
        }
    }

    public static UniqueDatabase getUniqueDatabase(String serverName, String databaseName, UniqueDatabase sibling) {
        try {
            UniqueDatabaseProvider provider = TestHelper.getUniqueDatabaseProvider();
            return provider.getUniqueDatabase().getConstructor(String.class, String.class, String.class, String.class).newInstance(serverName, databaseName, sibling.getIdentifier(), null);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create UniqueDatabase instance", e);
        }
    }

    public static UniqueDatabase getUniqueDatabase(String serverName, String databaseName, String charset) {
        try {
            UniqueDatabaseProvider provider = TestHelper.getUniqueDatabaseProvider();
            return provider.getUniqueDatabase().getConstructor(String.class, String.class, String.class, String.class).newInstance(serverName, databaseName, Integer.toUnsignedString(new Random().nextInt(), 36), charset);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create UniqueDatabase instance", e);
        }
    }

    public static UniqueDatabase getUniqueDatabase(String serverName, String databaseName, String identifier, String charset) {
        try {
            UniqueDatabaseProvider provider = TestHelper.getUniqueDatabaseProvider();
            return provider.getUniqueDatabase().getConstructor(String.class, String.class, String.class, String.class).newInstance(serverName, databaseName, identifier, charset);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create UniqueDatabase instance", e);
        }
    }

    private static UniqueDatabaseProvider getUniqueDatabaseProvider() {
        ServiceLoader<UniqueDatabaseProvider> loader = ServiceLoader.load(UniqueDatabaseProvider.class);
        return loader.findFirst().orElseThrow();
    }
}

