/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog.junit;

import io.debezium.connector.binlog.junit.SkipWhenGtidModeIs;
import io.debezium.connector.binlog.util.BinlogTestConnection;
import io.debezium.connector.binlog.util.TestConnectionService;
import io.debezium.junit.AnnotationBasedTestRule;
import java.sql.SQLException;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SkipTestDependingOnGtidModeRule
extends AnnotationBasedTestRule {
    private static final SkipWhenGtidModeIs.GtidMode gtidMode = SkipTestDependingOnGtidModeRule.getGtidMode();

    public Statement apply(Statement base, Description description) {
        SkipWhenGtidModeIs skipGtidMode = (SkipWhenGtidModeIs)this.hasAnnotation(description, SkipWhenGtidModeIs.class);
        if (skipGtidMode != null && skipGtidMode.value().equals((Object)gtidMode)) {
            String reasonForSkipping = "GTID_MODE is " + skipGtidMode.value() + System.lineSeparator() + skipGtidMode.reason();
            return SkipTestDependingOnGtidModeRule.emptyStatement((String)reasonForSkipping, (Description)description);
        }
        return base;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SkipWhenGtidModeIs.GtidMode getGtidMode() {
        try (BinlogTestConnection db = TestConnectionService.forTestDatabase("emptydb");){
            if (db.isMariaDb()) {
                SkipWhenGtidModeIs.GtidMode gtidMode2 = SkipWhenGtidModeIs.GtidMode.ON;
                return gtidMode2;
            }
            SkipWhenGtidModeIs.GtidMode gtidMode = (SkipWhenGtidModeIs.GtidMode)((Object)db.queryAndMap("SHOW GLOBAL VARIABLES LIKE 'GTID_MODE'", rs -> {
                if (rs.next()) {
                    return SkipWhenGtidModeIs.GtidMode.valueOf(rs.getString(2));
                }
                throw new IllegalStateException("Cannot obtain GTID status");
            }));
            return gtidMode;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cannot obtain GTID status", e);
        }
    }
}

