/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog.junit;

import io.debezium.connector.binlog.util.TestConnectionService;
import io.debezium.junit.DatabaseVersionResolver;

public class BinlogDatabaseVersionResolver
implements DatabaseVersionResolver {
    public boolean isMariaDb() {
        return TestConnectionService.forTestDatabase().isMariaDb();
    }

    public DatabaseVersionResolver.DatabaseVersion getVersion() {
        String version = TestConnectionService.forTestDatabase().getMySqlVersionString();
        String[] tokens = version.split("\\.");
        if (tokens.length == 0) {
            throw new IllegalStateException("Failed to resolve database version");
        }
        int major = BinlogDatabaseVersionResolver.sanitizeAndParseToken(tokens[0]);
        int minor = tokens.length >= 2 ? BinlogDatabaseVersionResolver.sanitizeAndParseToken(tokens[1]) : 0;
        int patch = tokens.length >= 3 ? BinlogDatabaseVersionResolver.sanitizeAndParseToken(tokens[2]) : 0;
        return new DatabaseVersionResolver.DatabaseVersion(major, minor, patch);
    }

    private static int sanitizeAndParseToken(String token) {
        String[] tokens = token.split("[^0-9]+");
        if (tokens.length == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(tokens[0]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

