/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.confluent.connect.avro.AvroData;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.binlog.BinlogOffsetContext;
import io.debezium.connector.binlog.BinlogSourceInfo;
import io.debezium.connector.binlog.history.BinlogHistoryRecordComparator;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.document.Document;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.avro.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BinlogSourceInfoTest<S extends BinlogSourceInfo, O extends BinlogOffsetContext<S>> {
    private static int avroSchemaCacheSize = 1000;
    private static final AvroData avroData = new AvroData(avroSchemaCacheSize);
    private static final String FILENAME = "mysql-bin.00001";
    private static final String GTID_SET = "gtid-set";
    private static final String SERVER_NAME = "my-server";
    private static final UUID IdA = UUID.fromString("123e4567-e89b-12d3-a456-426655440000");
    private static final UUID IdB = UUID.fromString("123e4567-e89b-12d3-a456-426655440001");
    private S source;
    private O offsetContext;
    private boolean inTxn = false;
    private long positionOfBeginEvent = 0L;
    private int eventNumberInTxn = 0;

    @Before
    public void beforeEach() {
        this.offsetContext = this.createInitialOffsetContext(((Configuration.Builder)Configuration.create().with(CommonConnectorConfig.TOPIC_PREFIX, "server")).build());
        this.source = this.offsetContext.getSource();
        this.inTxn = false;
        this.positionOfBeginEvent = 0L;
        this.eventNumberInTxn = 0;
    }

    @Test
    public void shouldStartSourceInfoFromZeroBinlogCoordinates() {
        this.offsetContext.setBinlogStartPoint(FILENAME, 0L);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((long)this.offsetContext.eventsToSkipUponRestart()).isEqualTo(0L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromNonZeroBinlogCoordinates() {
        this.offsetContext.setBinlogStartPoint(FILENAME, 100L);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithZeroBinlogCoordinates() {
        this.sourceWith(this.offset(0L, 0));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithNonZeroBinlogCoordinates() {
        this.sourceWith(this.offset(100L, 0));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithZeroBinlogCoordinatesAndNonZeroRow() {
        this.sourceWith(this.offset(0L, 5));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithNonZeroBinlogCoordinatesAndNonZeroRow() {
        this.sourceWith(this.offset(100L, 5));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithZeroBinlogCoordinatesAndSnapshot() {
        this.sourceWith(this.offset(0L, 0, true));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isTrue();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithNonZeroBinlogCoordinatesAndSnapshot() {
        this.sourceWith(this.offset(100L, 0, true));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isTrue();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithZeroBinlogCoordinatesAndNonZeroRowAndSnapshot() {
        this.sourceWith(this.offset(0L, 5, true));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isTrue();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithNonZeroBinlogCoordinatesAndNonZeroRowAndSnapshot() {
        this.sourceWith(this.offset(100L, 5, true));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isTrue();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndZeroBinlogCoordinates() {
        this.sourceWith(this.offset(GTID_SET, 0L, 0, false));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndZeroBinlogCoordinatesAndNonZeroRow() {
        this.sourceWith(this.offset(GTID_SET, 0L, 5, false));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndNonZeroBinlogCoordinates() {
        this.sourceWith(this.offset(GTID_SET, 100L, 0, false));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndNonZeroBinlogCoordinatesAndNonZeroRow() {
        this.sourceWith(this.offset(GTID_SET, 100L, 5, false));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndZeroBinlogCoordinatesAndSnapshot() {
        this.sourceWith(this.offset(GTID_SET, 0L, 0, true));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isTrue();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndZeroBinlogCoordinatesAndNonZeroRowAndSnapshot() {
        this.sourceWith(this.offset(GTID_SET, 0L, 5, true));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isTrue();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndNonZeroBinlogCoordinatesAndSnapshot() {
        this.sourceWith(this.offset(GTID_SET, 100L, 0, true));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(0);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isTrue();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndNonZeroBinlogCoordinatesAndNonZeroRowAndSnapshot() {
        this.sourceWith(this.offset(GTID_SET, 100L, 5, true));
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.binlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(5);
        Assertions.assertThat((boolean)this.offsetContext.isSnapshotRunning()).isTrue();
    }

    @Test
    public void shouldAdvanceSourceInfoFromNonZeroPositionAndRowZeroForEventsWithOneRow() {
        this.sourceWith(this.offset(100L, 0));
        this.handleTransactionBegin(150L, 2);
        this.handleNextEvent(200L, 10L, this.withRowCount(1));
        this.handleTransactionCommit(210L, 2);
        this.handleTransactionBegin(210L, 2);
        this.handleNextEvent(220L, 10L, this.withRowCount(1));
        this.handleTransactionCommit(230L, 3);
        this.handleTransactionBegin(240L, 2);
        this.handleNextEvent(250L, 50L, this.withRowCount(1));
        this.handleTransactionCommit(300L, 4);
        this.handleTransactionBegin(340L, 2);
        this.handleNextEvent(350L, 20L, this.withRowCount(1));
        this.handleNextEvent(370L, 30L, this.withRowCount(1));
        this.handleNextEvent(400L, 40L, this.withRowCount(1));
        this.handleTransactionCommit(440L, 4);
        this.handleTransactionBegin(500L, 2);
        this.handleNextEvent(510L, 20L, this.withRowCount(1));
        this.handleNextEvent(540L, 15L, this.withRowCount(1));
        this.handleNextEvent(560L, 10L, this.withRowCount(1));
        this.handleTransactionCommit(580L, 4);
        this.handleTransactionBegin(600L, 2);
        this.handleNextEvent(610L, 50L, this.withRowCount(1));
        this.handleTransactionCommit(660L, 4);
        this.handleNextEvent(670L, 10L, this.withRowCount(1));
        this.handleTransactionBegin(700L, 2);
        this.handleNextEvent(710L, 50L, this.withRowCount(1));
        this.handleTransactionCommit(760L, 4);
    }

    @Test
    public void shouldAdvanceSourceInfoFromNonZeroPositionAndRowZeroForEventsWithMultipleRow() {
        this.sourceWith(this.offset(100L, 0));
        this.handleTransactionBegin(150L, 2);
        this.handleNextEvent(200L, 10L, this.withRowCount(3));
        this.handleTransactionCommit(210L, 2);
        this.handleTransactionBegin(210L, 2);
        this.handleNextEvent(220L, 10L, this.withRowCount(4));
        this.handleTransactionCommit(230L, 3);
        this.handleTransactionBegin(240L, 2);
        this.handleNextEvent(250L, 50L, this.withRowCount(5));
        this.handleTransactionCommit(300L, 4);
        this.handleTransactionBegin(340L, 2);
        this.handleNextEvent(350L, 20L, this.withRowCount(6));
        this.handleNextEvent(370L, 30L, this.withRowCount(1));
        this.handleNextEvent(400L, 40L, this.withRowCount(3));
        this.handleTransactionCommit(440L, 4);
        this.handleTransactionBegin(500L, 2);
        this.handleNextEvent(510L, 20L, this.withRowCount(8));
        this.handleNextEvent(540L, 15L, this.withRowCount(9));
        this.handleNextEvent(560L, 10L, this.withRowCount(1));
        this.handleTransactionCommit(580L, 4);
        this.handleTransactionBegin(600L, 2);
        this.handleNextEvent(610L, 50L, this.withRowCount(1));
        this.handleTransactionCommit(660L, 4);
        this.handleNextEvent(670L, 10L, this.withRowCount(5));
        this.handleTransactionBegin(700L, 2);
        this.handleNextEvent(710L, 50L, this.withRowCount(3));
        this.handleTransactionCommit(760L, 4);
    }

    protected int withRowCount(int rowCount) {
        return rowCount;
    }

    protected void handleTransactionBegin(long positionOfEvent, int eventSize) {
        this.offsetContext.setEventPosition(positionOfEvent, (long)eventSize);
        this.positionOfBeginEvent = positionOfEvent;
        this.offsetContext.startNextTransaction();
        this.inTxn = true;
        Assertions.assertThat((int)this.offsetContext.rowsToSkipUponRestart()).isEqualTo(0);
    }

    protected void handleTransactionCommit(long positionOfEvent, int eventSize) {
        this.offsetContext.setEventPosition(positionOfEvent, (long)eventSize);
        this.offsetContext.commitTransaction();
        this.eventNumberInTxn = 0;
        this.inTxn = false;
        Map offset = this.offsetContext.getOffset();
        long position = (Long)offset.get("pos");
        Assertions.assertThat((long)position).isEqualTo(positionOfEvent + (long)eventSize);
        Long rowsToSkip = (Long)offset.get("row");
        if (rowsToSkip == null) {
            rowsToSkip = 0L;
        }
        Assertions.assertThat((Long)rowsToSkip).isEqualTo(0L);
        Assertions.assertThat(offset.get("event")).isNull();
        if (this.offsetContext.gtidSet() != null) {
            Assertions.assertThat(offset.get("gtids")).isEqualTo((Object)this.offsetContext.gtidSet());
        }
    }

    protected void handleNextEvent(long positionOfEvent, long eventSize, int rowCount) {
        if (this.inTxn) {
            ++this.eventNumberInTxn;
        }
        this.offsetContext.setEventPosition(positionOfEvent, eventSize);
        for (int row = 0; row != rowCount; ++row) {
            this.offsetContext.setRowNumber(row, rowCount);
            Map offset = this.offsetContext.getOffset();
            Assertions.assertThat(offset.get("file")).isEqualTo((Object)FILENAME);
            if (this.offsetContext.gtidSet() != null) {
                Assertions.assertThat(offset.get("gtids")).isEqualTo((Object)this.offsetContext.gtidSet());
            }
            long position = (Long)offset.get("pos");
            if (this.inTxn) {
                Assertions.assertThat((long)position).isEqualTo(this.positionOfBeginEvent);
                Long eventsToSkip = (Long)offset.get("event");
                if (eventsToSkip == null) {
                    eventsToSkip = 0L;
                }
                Assertions.assertThat((Long)eventsToSkip).isEqualTo((long)(this.eventNumberInTxn - 1));
            } else {
                Assertions.assertThat((long)position).isEqualTo(positionOfEvent + eventSize);
                Assertions.assertThat(offset.get("event")).isNull();
            }
            Long rowsToSkip = (Long)offset.get("row");
            if (rowsToSkip == null) {
                rowsToSkip = 0L;
            }
            if (row + 1 == rowCount) {
                Assertions.assertThat((Long)rowsToSkip).isEqualTo((long)rowCount);
            } else {
                Assertions.assertThat((Long)rowsToSkip).isEqualTo((long)(row + 1));
            }
            Struct recordSource = this.source.struct();
            Assertions.assertThat((Long)recordSource.getInt64("pos")).isEqualTo(positionOfEvent);
            Assertions.assertThat((Integer)recordSource.getInt32("row")).isEqualTo(row);
            Assertions.assertThat((String)recordSource.getString("file")).isEqualTo((Object)FILENAME);
            if (this.offsetContext.gtidSet() == null) continue;
            Assertions.assertThat((String)recordSource.getString("gtids")).isEqualTo((Object)this.offsetContext.gtidSet());
        }
        this.offsetContext.completeEvent();
    }

    protected Map<String, String> offset(long position, int row) {
        return this.offset(null, position, row, false);
    }

    protected Map<String, String> offset(long position, int row, boolean snapshot) {
        return this.offset(null, position, row, snapshot);
    }

    protected Map<String, String> offset(String gtidSet, long position, int row, boolean snapshot) {
        HashMap<String, String> offset = new HashMap<String, String>();
        offset.put("file", FILENAME);
        offset.put("pos", Long.toString(position));
        offset.put("row", Integer.toString(row));
        if (gtidSet != null) {
            offset.put("gtids", gtidSet);
        }
        if (snapshot) {
            offset.put("snapshot", Boolean.TRUE.toString());
        }
        return offset;
    }

    protected BinlogSourceInfo sourceWith(Map<String, String> offset) {
        this.offsetContext = this.loadOffsetContext(((Configuration.Builder)Configuration.create().with(CommonConnectorConfig.TOPIC_PREFIX, SERVER_NAME)).build(), offset);
        this.source = this.offsetContext.getSource();
        this.source.databaseEvent("mysql");
        return this.source;
    }

    @Test
    public void shouldValidateSourceInfoSchema() {
        org.apache.kafka.connect.data.Schema kafkaSchema = this.source.schema();
        Schema avroSchema = avroData.fromConnectSchema(kafkaSchema);
        Assert.assertTrue((avroSchema != null ? 1 : 0) != 0);
    }

    @Test
    public void shouldConsiderPositionsWithSameGtidSetsAsSame() {
        this.assertPositionWithGtids(String.format("%s:1-5", IdA)).isAtOrBefore(this.positionWithGtids(String.format("%s:1-5", IdA)));
        this.assertPositionWithGtids(String.format("%s:1-5,%s:1-20", IdA, IdB)).isAtOrBefore(this.positionWithGtids(String.format("%s:1-5,%s:1-20", IdA, IdB)));
        this.assertPositionWithGtids(String.format("%s:1-5,%s:1-20", IdA, IdB)).isAtOrBefore(this.positionWithGtids(String.format("%s:1-20,%s:1-5", IdB, IdA)));
    }

    @Test
    public void shouldConsiderPositionsWithSameGtidSetsAndSnapshotAsSame() {
        this.assertPositionWithGtids(String.format("%s:1-5", IdA), true).isAtOrBefore(this.positionWithGtids(String.format("%s:1-5", IdA), true));
        this.assertPositionWithGtids(String.format("%s:1-5,%s:1-20", IdA, IdB), true).isAtOrBefore(this.positionWithGtids(String.format("%s:1-5,%s:1-20", IdA, IdB), true));
        this.assertPositionWithGtids(String.format("%s:1-5,%s:1-20", IdA, IdB), true).isAtOrBefore(this.positionWithGtids(String.format("%s:1-20,%s:1-5", IdB, IdA), true));
    }

    @Test
    public void shouldOrderPositionWithGtidAndSnapshotBeforePositionWithSameGtidButNoSnapshot() {
        this.assertPositionWithGtids(String.format("%s:1-5", IdA), true).isBefore(this.positionWithGtids(String.format("%s:1-5", IdA), false));
        this.assertPositionWithGtids(String.format("%s:1-5", IdA), true).isAtOrBefore(this.positionWithGtids(String.format("%s:1-5", IdA)));
        this.assertPositionWithGtids(String.format("%s:1-5,%s:1-20", IdA, IdB), true).isAtOrBefore(this.positionWithGtids(String.format("%s:1-5,%s:1-20", IdA, IdB)));
        this.assertPositionWithGtids(String.format("%s:1-5,%s:1-20", IdA, IdB), true).isAtOrBefore(this.positionWithGtids(String.format("%s:1-20,%s:1-5", IdB, IdA)));
    }

    @Test
    public void shouldOrderPositionWithoutGtidAndSnapshotAfterPositionWithSameGtidAndSnapshot() {
        this.assertPositionWithGtids(String.format("%s:1-5", IdA), false).isAfter(this.positionWithGtids(String.format("%s:1-5", IdA), true));
        this.assertPositionWithGtids(String.format("%s:1-5,%s:1-20", IdA, IdB), false).isAfter(this.positionWithGtids(String.format("%s:1-5,%s:1-20", IdA, IdB), true));
        this.assertPositionWithGtids(String.format("%s:1-5,%s:1-20", IdA, IdB), false).isAfter(this.positionWithGtids(String.format("%s:1-20,%s:1-5", IdB, IdA), true));
    }

    @Test
    public void shouldOrderPositionWithGtidsAsBeforePositionWithExtraServerUuidInGtids() {
        this.assertPositionWithGtids(String.format("%s:1-5", IdA)).isBefore(this.positionWithGtids(String.format("%s:1-5,%s:1-20", IdA, IdB)));
    }

    @Test
    public void shouldOrderPositionsWithSameServerButLowerUpperLimitAsBeforePositionWithSameServerUuidInGtids() {
        this.assertPositionWithGtids(String.format("%s:1-5", IdA)).isBefore(this.positionWithGtids(String.format("%s:1-6", IdA)));
        this.assertPositionWithGtids(String.format("%s:1-5:7-9", IdA)).isBefore(this.positionWithGtids(String.format("%s:1-10", IdA)));
        this.assertPositionWithGtids(String.format("%s:2-5:8-9", IdA)).isBefore(this.positionWithGtids(String.format("%s:1-10", IdA)));
    }

    @Test
    public void shouldOrderPositionWithoutGtidAsBeforePositionWithGtid() {
        this.assertPositionWithoutGtids("filename.01", Integer.MAX_VALUE, 0, 0).isBefore(this.positionWithGtids("IdA:1-5"));
    }

    @Test
    public void shouldOrderPositionWithGtidAsAfterPositionWithoutGtid() {
        this.assertPositionWithGtids(String.format("%s:1-5", IdA)).isAfter(this.positionWithoutGtids("filename.01", 0, 0, 0));
    }

    @Test
    public void shouldComparePositionsWithoutGtids() {
        this.assertPositionWithoutGtids("fn.01", 1, 0, 0).isAt(this.positionWithoutGtids("fn.01", 1, 0, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 0, 1).isAt(this.positionWithoutGtids("fn.01", 1, 0, 1));
        this.assertPositionWithoutGtids("fn.03", 1, 0, 1).isAt(this.positionWithoutGtids("fn.03", 1, 0, 1));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 0).isAt(this.positionWithoutGtids("fn.01", 1, 1, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 1).isAt(this.positionWithoutGtids("fn.01", 1, 1, 1));
        this.assertPositionWithoutGtids("fn.03", 1, 1, 1).isAt(this.positionWithoutGtids("fn.03", 1, 1, 1));
        this.assertPositionWithoutGtids("fn.01", 1, 0, 0).isBefore(this.positionWithoutGtids("fn.01", 1, 0, 1));
        this.assertPositionWithoutGtids("fn.01", 1, 0, 0).isBefore(this.positionWithoutGtids("fn.01", 2, 0, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 0, 1).isBefore(this.positionWithoutGtids("fn.01", 1, 0, 2));
        this.assertPositionWithoutGtids("fn.01", 1, 0, 1).isBefore(this.positionWithoutGtids("fn.01", 2, 0, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 0).isBefore(this.positionWithoutGtids("fn.01", 1, 1, 1));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 0).isBefore(this.positionWithoutGtids("fn.01", 1, 2, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 1).isBefore(this.positionWithoutGtids("fn.01", 1, 2, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 1).isBefore(this.positionWithoutGtids("fn.01", 2, 0, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 0, 1).isAfter(this.positionWithoutGtids("fn.01", 0, 0, 99));
        this.assertPositionWithoutGtids("fn.01", 1, 0, 1).isAfter(this.positionWithoutGtids("fn.01", 1, 0, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 1).isAfter(this.positionWithoutGtids("fn.01", 0, 0, 99));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 1).isAfter(this.positionWithoutGtids("fn.01", 1, 0, 0));
        this.assertPositionWithoutGtids("fn.01", 1, 1, 1).isAfter(this.positionWithoutGtids("fn.01", 1, 1, 0));
    }

    @Test
    public void shouldComparePositionsWithDifferentFields() {
        Document history = this.positionWith("mysql-bin.000008", 380941551, "01261278-6ade-11e6-b36a-42010af00790:1-378422946,4d1a4918-44ba-11e6-bf12-42010af0040b:1-11002284,716ec46f-d522-11e5-bb56-0242ac110004:1-34673215,96c2072e-e428-11e6-9590-42010a28002d:1-3,c627b2bc-9647-11e6-a886-42010af0044a:1-9541144", 0, 0, true);
        Document current = this.positionWith("mysql-bin.000016", 645115324, "01261278-6ade-11e6-b36a-42010af00790:1-400944168,30efb117-e42a-11e6-ba9e-42010a28002e:1-9,4d1a4918-44ba-11e6-bf12-42010af0040b:1-11604379,621dc2f6-803b-11e6-acc1-42010af000a4:1-7963838,716ec46f-d522-11e5-bb56-0242ac110004:1-35850702,c627b2bc-9647-11e6-a886-42010af0044a:1-10426868,d079cbb3-750f-11e6-954e-42010af00c28:1-11544291:11544293-11885648", 2, 1, false);
        this.assertThatDocument(current).isAfter(history);
        Set<String> excludes = Collections.singleton("96c2072e-e428-11e6-9590-42010a28002d");
        this.assertThatDocument(history).isAtOrBefore(current, uuid -> !excludes.contains(uuid));
    }

    @Test
    public void shouldComparePositionsWithDifferentFilenames() {
        Document history = this.positionWithoutGtids("mysql-bin.000001", 1, 0, 0);
        this.assertThatDocument(history).isAtOrBefore(this.positionWithoutGtids("mysql-bin.000001", 1, 0, 0));
        this.assertThatDocument(history).isAtOrBefore(this.positionWithoutGtids("mysql-bin.000002", 1, 0, 0));
        history = this.positionWithoutGtids("mysql-bin.200001", 1, 0, 0);
        this.assertThatDocument(history).isAfter(this.positionWithoutGtids("mysql-bin.100001", 1, 0, 0));
        this.assertThatDocument(history).isAtOrBefore(this.positionWithoutGtids("mysql-bin.1000111", 1, 0, 0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotComparePositionsWithDifferentFilenameFormats() {
        Document history = this.positionWithoutGtids("mysql-bin.000001", 1, 0, 0);
        this.assertThatDocument(history).isAtOrBefore(this.positionWithoutGtids("mysql-binlog-filename.000001", 1, 0, 0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotComparePositionsWithInvalidFilenameFormat() {
        Document history = this.positionWithoutGtids("mysql-bin.000001", 1, 0, 0);
        this.assertThatDocument(history).isAtOrBefore(this.positionWithoutGtids("mysql-bin", 1, 0, 0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotComparePositionsWithNotNumericFilenameExtension() {
        Document history = this.positionWithoutGtids("mysql-bin.000001", 1, 0, 0);
        this.assertThatDocument(history).isAtOrBefore(this.positionWithoutGtids("mysql-bin.not-numeric", 1, 0, 0));
    }

    @Test
    @FixFor(value={"DBZ-107"})
    public void shouldRemoveNewlinesFromGtidSet() {
        String gtidExecuted = "036d85a9-64e5-11e6-9b48-42010af0000c:1-2,\n7145bf69-d1ca-11e5-a588-0242ac110004:1-3149,\n7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-39";
        String gtidCleaned = "036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3149,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-39";
        this.offsetContext.setCompletedGtidSet(gtidExecuted);
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isEqualTo((Object)gtidCleaned);
    }

    @Test
    @FixFor(value={"DBZ-107"})
    public void shouldNotSetBlankGtidSet() {
        this.offsetContext.setCompletedGtidSet("");
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isNull();
    }

    @Test
    @FixFor(value={"DBZ-107"})
    public void shouldNotSetNullGtidSet() {
        this.offsetContext.setCompletedGtidSet(null);
        Assertions.assertThat((String)this.offsetContext.gtidSet()).isNull();
    }

    @Test
    public void shouldHaveTimestamp() {
        this.sourceWith(this.offset(100L, 5, true));
        this.source.setSourceTime(Instant.ofEpochSecond(1024L, 0L));
        this.source.databaseEvent("mysql");
        Assertions.assertThat((Object)this.source.struct().get("ts_ms")).isEqualTo((Object)1024000L);
    }

    @Test
    public void versionIsPresent() {
        this.sourceWith(this.offset(100L, 5, true));
        this.source.databaseEvent("mysql");
        Assertions.assertThat((String)this.source.struct().getString("version")).isEqualTo((Object)this.getModuleVersion());
    }

    @Test
    public void connectorIsPresent() {
        this.sourceWith(this.offset(100L, 5, true));
        this.source.databaseEvent("mysql");
        Assertions.assertThat((String)this.source.struct().getString("connector")).isEqualTo((Object)this.getModuleName());
    }

    @Test
    public void schemaIsCorrect() {
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().name(String.format("io.debezium.connector.%s.Source", this.getModuleName())).field("version", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).field("connector", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).field("name", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).field("ts_ms", org.apache.kafka.connect.data.Schema.INT64_SCHEMA).field("snapshot", AbstractSourceInfoStructMaker.SNAPSHOT_RECORD_SCHEMA).field("db", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).field("sequence", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).field("ts_us", org.apache.kafka.connect.data.Schema.OPTIONAL_INT64_SCHEMA).field("ts_ns", org.apache.kafka.connect.data.Schema.OPTIONAL_INT64_SCHEMA).field("table", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).field("server_id", org.apache.kafka.connect.data.Schema.INT64_SCHEMA).field("gtid", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).field("file", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).field("pos", org.apache.kafka.connect.data.Schema.INT64_SCHEMA).field("row", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).field("thread", org.apache.kafka.connect.data.Schema.OPTIONAL_INT64_SCHEMA).field("query", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).build();
        VerifyRecord.assertConnectSchemasAreEqual(null, (org.apache.kafka.connect.data.Schema)this.source.schema(), (org.apache.kafka.connect.data.Schema)schema);
    }

    protected abstract String getModuleName();

    protected abstract String getModuleVersion();

    protected abstract BinlogHistoryRecordComparator getHistoryRecordComparator(Predicate<String> var1);

    protected abstract O createInitialOffsetContext(Configuration var1);

    protected abstract O loadOffsetContext(Configuration var1, Map<String, ?> var2);

    protected Document positionWithGtids(String gtids) {
        return this.positionWithGtids(gtids, false);
    }

    protected Document positionWithGtids(String gtids, boolean snapshot) {
        if (snapshot) {
            return Document.create((CharSequence)"gtids", (Object)gtids, (CharSequence)"snapshot", (Object)true);
        }
        return Document.create((CharSequence)"gtids", (Object)gtids);
    }

    protected Document positionWithoutGtids(String filename, int position, int event, int row) {
        return this.positionWithoutGtids(filename, position, event, row, false);
    }

    protected Document positionWithoutGtids(String filename, int position, int event, int row, boolean snapshot) {
        return this.positionWith(filename, position, null, event, row, snapshot);
    }

    protected Document positionWith(String filename, int position, String gtids, int event, int row, boolean snapshot) {
        Document pos = Document.create((CharSequence)"file", (Object)filename, (CharSequence)"pos", (Object)position);
        if (row >= 0) {
            pos = pos.set((CharSequence)"row", (Object)row);
        }
        if (event >= 0) {
            pos = pos.set((CharSequence)"event", (Object)event);
        }
        if (gtids != null && gtids.trim().length() != 0) {
            pos = pos.set((CharSequence)"gtids", (Object)gtids);
        }
        if (snapshot) {
            pos = pos.set((CharSequence)"snapshot", (Object)true);
        }
        return pos;
    }

    protected PositionAssert assertThatDocument(Document position) {
        return new PositionAssert(position, this::getHistoryRecordComparator);
    }

    protected PositionAssert assertPositionWithGtids(String gtids) {
        return this.assertThatDocument(this.positionWithGtids(gtids));
    }

    protected PositionAssert assertPositionWithGtids(String gtids, boolean snapshot) {
        return this.assertThatDocument(this.positionWithGtids(gtids, snapshot));
    }

    protected PositionAssert assertPositionWithoutGtids(String filename, int position, int event, int row) {
        return this.assertPositionWithoutGtids(filename, position, event, row, false);
    }

    protected PositionAssert assertPositionWithoutGtids(String filename, int position, int event, int row, boolean snapshot) {
        return this.assertThatDocument(this.positionWithoutGtids(filename, position, event, row, snapshot));
    }

    protected static class PositionAssert
    extends AbstractAssert<PositionAssert, Document> {
        private final HistoryRecordComparatorProvider historyRecordComparatorProvider;

        public PositionAssert(Document position, HistoryRecordComparatorProvider historyRecordComparatorProvider) {
            super((Object)position, PositionAssert.class);
            this.historyRecordComparatorProvider = historyRecordComparatorProvider;
        }

        public PositionAssert isAt(Document otherPosition) {
            return this.isAt(otherPosition, null);
        }

        public PositionAssert isAt(Document otherPosition, Predicate<String> gtidFilter) {
            BinlogHistoryRecordComparator comparator = this.historyRecordComparatorProvider.getHistoryRecordComparator(gtidFilter);
            if (comparator.isPositionAtOrBefore((Document)this.actual, otherPosition)) {
                return this;
            }
            this.failWithMessage(this.actual + " should be consider same position as " + otherPosition, new Object[0]);
            return this;
        }

        public PositionAssert isBefore(Document otherPosition) {
            return this.isBefore(otherPosition, null);
        }

        public PositionAssert isBefore(Document otherPosition, Predicate<String> gtidFilter) {
            return this.isAtOrBefore(otherPosition, gtidFilter);
        }

        public PositionAssert isAtOrBefore(Document otherPosition) {
            return this.isAtOrBefore(otherPosition, null);
        }

        public PositionAssert isAtOrBefore(Document otherPosition, Predicate<String> gtidFilter) {
            BinlogHistoryRecordComparator comparator = this.historyRecordComparatorProvider.getHistoryRecordComparator(gtidFilter);
            if (!comparator.isPositionAtOrBefore((Document)this.actual, otherPosition)) {
                this.failWithMessage(this.actual + " should be consider same position as or before " + otherPosition, new Object[0]);
            }
            return this;
        }

        public PositionAssert isAfter(Document otherPosition) {
            return this.isAfter(otherPosition, null);
        }

        public PositionAssert isAfter(Document otherPosition, Predicate<String> gtidFilter) {
            BinlogHistoryRecordComparator comparator = this.historyRecordComparatorProvider.getHistoryRecordComparator(gtidFilter);
            if (comparator.isPositionAtOrBefore((Document)this.actual, otherPosition)) {
                this.failWithMessage(this.actual + " should be consider after " + otherPosition, new Object[0]);
            }
            return this;
        }
    }

    @FunctionalInterface
    static interface HistoryRecordComparatorProvider {
        public BinlogHistoryRecordComparator getHistoryRecordComparator(Predicate<String> var1);
    }
}

