/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.connector.binlog.AbstractBinlogConnectorIT;
import io.debezium.connector.binlog.util.BinlogTestConnection;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenDatabaseVersion;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.kafka.connect.source.SourceConnector;
import org.junit.Ignore;
import org.junit.Test;

@SkipWhenDatabaseVersion(check=EqualityCheck.LESS_THAN, major=5, minor=6, patch=5, reason="MySQL 5.5 does not support CURRENT_TIMESTAMP on DATETIME and only a single column can specify default CURRENT_TIMESTAMP, lifted in MySQL 5.6.5")
public abstract class BinlogConnectionIT<C extends SourceConnector>
extends AbstractBinlogConnectorIT<C> {
    @Ignore
    @Test
    public void shouldConnectToDefaultDatabase() throws SQLException {
        try (BinlogTestConnection conn = this.getTestDatabaseConnection("mysql");){
            conn.connect();
        }
    }

    @Test
    public void shouldDoStuffWithDatabase() throws SQLException {
        UniqueDatabase DATABASE = TestHelper.getUniqueDatabase("readbinlog", "readbinlog_test");
        DATABASE.createAndInitialize();
        try (BinlogTestConnection conn = this.getTestDatabaseConnection(DATABASE.getDatabaseName());){
            conn.connect();
            conn.execute(new String[]{"DROP TABLE IF EXISTS person", "CREATE TABLE person (  name VARCHAR(255) primary key,  birthdate DATE NULL,  age INTEGER NULL DEFAULT 10,  salary DECIMAL(5,2),  bitStr BIT(18))"});
            conn.execute(new String[]{"SELECT * FROM person"});
            ResultSet rs = conn.connection().getMetaData().getColumns("readbinlog_test", null, null, null);
            if (rs != null) {
                rs.close();
            }
        }
    }

    @Ignore
    @Test
    public void shouldConnectToEmptyDatabase() throws SQLException {
        try (BinlogTestConnection conn = this.getTestDatabaseConnection("emptydb");){
            conn.connect();
        }
    }
}

