/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.AbstractBinlogConnectorIT;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BinlogBinaryModeIT<C extends SourceConnector>
extends AbstractBinlogConnectorIT<C> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-binary-mode.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = TestHelper.getUniqueDatabase("binarymodeit", "binary_mode_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-1814"})
    public void shouldReceiveRawBinary() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.NEVER)).with(BinlogConnectorConfig.BINARY_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.BinaryHandlingMode.BYTES)).build();
        this.start(this.getConnectorClass(), this.config);
        int createDatabaseCount = 1;
        int createTableCount = 1;
        int insertCount = 1;
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(createDatabaseCount + createTableCount + insertCount);
        this.stopConnector();
        Assertions.assertThat((Object)sourceRecords).isNotNull();
        List topicSourceRecords = sourceRecords.recordsForTopic(this.DATABASE.topicForTable("dbz_1814_binary_mode_test"));
        Assertions.assertThat((List)topicSourceRecords).hasSize(1);
        SourceRecord topicSourceRecord = (SourceRecord)topicSourceRecords.get(0);
        Struct kafkaDataStructure = (Struct)((Struct)topicSourceRecord.value()).get("after");
        ByteBuffer expectedValue = ByteBuffer.wrap(new byte[]{1, 2, 3});
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("blob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("tinyblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("mediumblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("longblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("binary_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("varbinary_col"));
        sourceRecords.forEach(x$0 -> this.validate((SourceRecord)x$0));
    }

    @Test
    @FixFor(value={"DBZ-1814"})
    public void shouldReceiveHexBinary() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.NEVER)).with(BinlogConnectorConfig.BINARY_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.BinaryHandlingMode.HEX)).build();
        this.start(this.getConnectorClass(), this.config);
        int createDatabaseCount = 1;
        int createTableCount = 1;
        int insertCount = 1;
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(createDatabaseCount + createTableCount + insertCount);
        this.stopConnector();
        Assertions.assertThat((Object)sourceRecords).isNotNull();
        List topicSourceRecords = sourceRecords.recordsForTopic(this.DATABASE.topicForTable("dbz_1814_binary_mode_test"));
        Assertions.assertThat((List)topicSourceRecords).hasSize(1);
        SourceRecord topicSourceRecord = (SourceRecord)topicSourceRecords.get(0);
        Struct kafkaDataStructure = (Struct)((Struct)topicSourceRecord.value()).get("after");
        String expectedValue = "010203";
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("blob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("tinyblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("mediumblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("longblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("binary_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("varbinary_col"));
        sourceRecords.forEach(x$0 -> this.validate((SourceRecord)x$0));
    }

    @Test
    @FixFor(value={"DBZ-1814"})
    public void shouldReceiveBase64Binary() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.NEVER)).with(BinlogConnectorConfig.BINARY_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.BinaryHandlingMode.BASE64)).build();
        this.start(this.getConnectorClass(), this.config);
        int createDatabaseCount = 1;
        int createTableCount = 1;
        int insertCount = 1;
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(createDatabaseCount + createTableCount + insertCount);
        this.stopConnector();
        Assertions.assertThat((Object)sourceRecords).isNotNull();
        List topicSourceRecords = sourceRecords.recordsForTopic(this.DATABASE.topicForTable("dbz_1814_binary_mode_test"));
        Assertions.assertThat((List)topicSourceRecords).hasSize(1);
        SourceRecord topicSourceRecord = (SourceRecord)topicSourceRecords.get(0);
        Struct kafkaDataStructure = (Struct)((Struct)topicSourceRecord.value()).get("after");
        String expectedValue = "AQID";
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("blob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("tinyblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("mediumblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("longblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("binary_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("varbinary_col"));
        sourceRecords.forEach(x$0 -> this.validate((SourceRecord)x$0));
    }

    @Test
    @FixFor(value={"DBZ-5544"})
    public void shouldReceiveBase64UrlSafeBinary() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.NEVER)).with(BinlogConnectorConfig.BINARY_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.BinaryHandlingMode.BASE64_URL_SAFE)).build();
        this.start(this.getConnectorClass(), this.config);
        int createDatabaseCount = 1;
        int createTableCount = 1;
        int insertCount = 1;
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(createDatabaseCount + createTableCount + insertCount);
        this.stopConnector();
        Assertions.assertThat((Object)sourceRecords).isNotNull();
        List topicSourceRecords = sourceRecords.recordsForTopic(this.DATABASE.topicForTable("dbz_1814_binary_mode_test"));
        Assertions.assertThat((List)topicSourceRecords).hasSize(1);
        SourceRecord topicSourceRecord = (SourceRecord)topicSourceRecords.get(0);
        Struct kafkaDataStructure = (Struct)((Struct)topicSourceRecord.value()).get("after");
        String expectedValue = "AQID";
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("blob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("tinyblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("mediumblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("longblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("binary_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("varbinary_col"));
        sourceRecords.forEach(x$0 -> this.validate((SourceRecord)x$0));
    }
}

