/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog.util;

import io.debezium.config.Configuration;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import java.sql.SQLException;

public abstract class BinlogTestConnection
extends JdbcConnection {
    public BinlogTestConnection(JdbcConfiguration config, JdbcConnection.ConnectionFactory factory) {
        super(BinlogTestConnection.addDefaultSettings(config), factory, "`", "`");
    }

    public boolean isTableIdCaseSensitive() {
        String caseString;
        try {
            caseString = (String)this.connect().queryAndMap("SHOW GLOBAL VARIABLES LIKE 'lower_case_table_names'", rs -> {
                rs.next();
                return rs.getString(2);
            });
        }
        catch (SQLException e) {
            throw new IllegalStateException("Couldn't obtain MySQL Server version comment", e);
        }
        return !"0".equals(caseString);
    }

    public String getMySqlVersionString() {
        String versionString;
        try {
            versionString = (String)this.connect().queryAndMap("SHOW GLOBAL VARIABLES LIKE 'version'", rs -> {
                rs.next();
                return rs.getString(2);
            });
        }
        catch (SQLException e) {
            throw new IllegalStateException("Couldn't obtain MySQL Server version", e);
        }
        return versionString;
    }

    public abstract boolean isGtidEnabled();

    public abstract boolean isMariaDb();

    public abstract boolean isMySQL5();

    public abstract boolean isPercona();

    public abstract String currentDateTimeDefaultOptional(String var1);

    public abstract void setBinlogCompressionOff() throws SQLException;

    public abstract void setBinlogCompressionOn() throws SQLException;

    public abstract void setBinlogRowQueryEventsOff() throws SQLException;

    public abstract void setBinlogRowQueryEventsOn() throws SQLException;

    public abstract boolean isCurrentDateTimeDefaultGenerated();

    protected static JdbcConfiguration addDefaultSettings(JdbcConfiguration configuration) {
        return JdbcConfiguration.adapt((Configuration)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)configuration.edit().withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 3306)).withDefault(JdbcConfiguration.USER, "mysqluser")).withDefault(JdbcConfiguration.PASSWORD, "mysqlpw")).build());
    }

    protected static JdbcConfiguration.Builder getDefaultJdbcConfig(String databaseName) {
        return (JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.").merge(new Configuration[]{Configuration.fromSystemProperties((String)"driver.")})).withDatabase(databaseName).with("characterEncoding", "utf8");
    }

    protected static JdbcConfiguration.Builder getReplicaJdbcConfig(String databaseName) {
        return (JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.replica.").merge(new Configuration[]{Configuration.fromSystemProperties((String)"driver.").merge(new Configuration[]{Configuration.fromSystemProperties((String)"database.")})})).withDatabase(databaseName).with("characterEncoding", "utf8");
    }
}

