/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.connector.binlog.BinlogUnsignedIntegerConverter;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

public class BinlogUnsignedIntegerConverterTest {
    @Test
    public void shouldConvertSignedBinlogTinyintToUnsigned() {
        Assert.assertEquals((long)255L, (long)BinlogUnsignedIntegerConverter.convertUnsignedTinyint((short)-1));
        Assert.assertEquals((long)255L, (long)BinlogUnsignedIntegerConverter.convertUnsignedTinyint((short)255));
    }

    @Test
    public void shouldConvertSignedBinlogSmallintToUnsigned() {
        Assert.assertEquals((long)65535L, (long)BinlogUnsignedIntegerConverter.convertUnsignedSmallint((int)-1));
        Assert.assertEquals((long)65535L, (long)BinlogUnsignedIntegerConverter.convertUnsignedSmallint((int)65535));
    }

    @Test
    public void shouldConvertSignedBinlogMediumintToUnsigned() {
        Assert.assertEquals((long)0xFFFFFFL, (long)BinlogUnsignedIntegerConverter.convertUnsignedMediumint((int)-1));
        Assert.assertEquals((long)0xFFFFFFL, (long)BinlogUnsignedIntegerConverter.convertUnsignedMediumint((int)0xFFFFFF));
    }

    @Test
    public void shouldConvertSignedBinlogIntToUnsigned() {
        Assert.assertEquals((long)0xFFFFFFFFL, (long)BinlogUnsignedIntegerConverter.convertUnsignedInteger((long)-1L));
        Assert.assertEquals((long)0xFFFFFFFFL, (long)BinlogUnsignedIntegerConverter.convertUnsignedInteger((long)0xFFFFFFFFL));
    }

    @Test
    public void shouldConvertSignedBinlogBigintToUnsigned() {
        Assert.assertEquals((Object)new BigDecimal("18446744073709551615"), (Object)BinlogUnsignedIntegerConverter.convertUnsignedBigint((BigDecimal)new BigDecimal("-1")));
        Assert.assertEquals((Object)new BigDecimal("18446744073709551615"), (Object)BinlogUnsignedIntegerConverter.convertUnsignedBigint((BigDecimal)new BigDecimal("18446744073709551615")));
    }
}

