/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.AbstractBinlogConnectorIT;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class BinlogTableMaintenanceStatementsIT<C extends SourceConnector>
extends AbstractBinlogConnectorIT<C> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-table-maintenance.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = TestHelper.getUniqueDatabase("tablemaintenanceit", "table_maintenance_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-253"})
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(this.getConnectorClass(), this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 1;
        int numTableMaintenanceStatements = 3;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numTableMaintenanceStatements);
        System.out.println(records.allRecordsInOrder());
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numCreateDatabase + numCreateTables + numTableMaintenanceStatements);
        Assertions.assertThat((Iterable)records.databaseNames()).containsOnly((Object[])new String[]{this.DATABASE.getDatabaseName()});
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(numCreateDatabase + numCreateTables + numTableMaintenanceStatements);
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
    }
}

