/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.AbstractBinlogConnectorIT;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.util.BinlogTestConnection;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class BinlogSkipMessagesWithoutChangeConfigIT<C extends SourceConnector>
extends AbstractBinlogConnectorIT<C> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-decimal.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = TestHelper.getUniqueDatabase("skip_messages_db", "skip_messages_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-2979"})
    public void shouldSkipEventsWithNoChangeInIncludedColumnsWhenSkipEnabled() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.COLUMN_INCLUDE_LIST, this.getQualifiedColumnName("id") + "," + this.getQualifiedColumnName("white"))).with(BinlogConnectorConfig.SKIP_MESSAGES_WITHOUT_CHANGE, true)).with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(this.getConnectorClass(), this.config);
        BinlogSkipMessagesWithoutChangeConfigIT.waitForStreamingRunning((String)this.getConnectorName(), (String)this.DATABASE.getServerName());
        try (BinlogTestConnection db = this.getTestDatabaseConnection(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"insert into debezium_test(id, black, white) values(1, 1, 1)"});
            connection.execute(new String[]{"UPDATE debezium_test SET black=2 where id = 1"});
            connection.execute(new String[]{"UPDATE debezium_test SET white=2 where id = 1"});
            connection.execute(new String[]{"UPDATE debezium_test SET white=3, black=3 where id = 1"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(6);
        List recordsForTopic = records.recordsForTopic(this.DATABASE.topicForTable("debezium_test"));
        Assertions.assertThat((List)recordsForTopic).hasSize(4);
        Struct thirdMessage = ((Struct)((SourceRecord)recordsForTopic.get(2)).value()).getStruct("after");
        Assertions.assertThat((Object)thirdMessage.get("white")).isEqualTo((Object)2);
        Struct forthMessage = ((Struct)((SourceRecord)recordsForTopic.get(3)).value()).getStruct("after");
        Assertions.assertThat((Object)forthMessage.get("white")).isEqualTo((Object)3);
    }

    @Test
    @FixFor(value={"DBZ-2979"})
    public void shouldSkipEventsWithNoChangeInIncludedColumnsWhenSkipEnabledWithExcludeConfig() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.COLUMN_EXCLUDE_LIST, this.getQualifiedColumnName("black"))).with(BinlogConnectorConfig.SKIP_MESSAGES_WITHOUT_CHANGE, true)).with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(this.getConnectorClass(), this.config);
        BinlogSkipMessagesWithoutChangeConfigIT.waitForStreamingRunning((String)this.getConnectorName(), (String)this.DATABASE.getServerName());
        try (BinlogTestConnection db = this.getTestDatabaseConnection(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"insert into debezium_test(id, black, white) values(1, 1, 1)"});
            connection.execute(new String[]{"UPDATE debezium_test SET black=2 where id = 1"});
            connection.execute(new String[]{"UPDATE debezium_test SET white=2 where id = 1"});
            connection.execute(new String[]{"UPDATE debezium_test SET white=3, black=3 where id = 1"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(6);
        List recordsForTopic = records.recordsForTopic(this.DATABASE.topicForTable("debezium_test"));
        Assertions.assertThat((List)recordsForTopic).hasSize(4);
        Struct thirdMessage = ((Struct)((SourceRecord)recordsForTopic.get(2)).value()).getStruct("after");
        Assertions.assertThat((Object)thirdMessage.get("white")).isEqualTo((Object)2);
        Struct forthMessage = ((Struct)((SourceRecord)recordsForTopic.get(3)).value()).getStruct("after");
        Assertions.assertThat((Object)forthMessage.get("white")).isEqualTo((Object)3);
    }

    @Test
    @FixFor(value={"DBZ-2979"})
    public void shouldNotSkipEventsWithNoChangeInIncludedColumnsWhenSkipDisabled() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.COLUMN_INCLUDE_LIST, this.getQualifiedColumnName("id") + "," + this.getQualifiedColumnName("white"))).with(BinlogConnectorConfig.SKIP_MESSAGES_WITHOUT_CHANGE, false)).with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(this.getConnectorClass(), this.config);
        BinlogSkipMessagesWithoutChangeConfigIT.waitForStreamingRunning((String)this.getConnectorName(), (String)this.DATABASE.getServerName());
        try (BinlogTestConnection db = this.getTestDatabaseConnection(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"insert into debezium_test(id, black, white) values(1, 1, 1)"});
            connection.execute(new String[]{"UPDATE debezium_test SET black=2 where id = 1"});
            connection.execute(new String[]{"UPDATE debezium_test SET white=2 where id = 1"});
            connection.execute(new String[]{"UPDATE debezium_test SET white=3, black=3 where id = 1"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        List recordsForTopic = records.recordsForTopic(this.DATABASE.topicForTable("debezium_test"));
        Assertions.assertThat((List)recordsForTopic).hasSize(5);
        Struct thirdMessage = ((Struct)((SourceRecord)recordsForTopic.get(2)).value()).getStruct("after");
        Assertions.assertThat((Object)thirdMessage.get("white")).isEqualTo((Object)1);
        Struct forthMessage = ((Struct)((SourceRecord)recordsForTopic.get(3)).value()).getStruct("after");
        Assertions.assertThat((Object)forthMessage.get("white")).isEqualTo((Object)2);
        Struct fifthMessage = ((Struct)((SourceRecord)recordsForTopic.get(4)).value()).getStruct("after");
        Assertions.assertThat((Object)fifthMessage.get("white")).isEqualTo((Object)3);
    }

    String getQualifiedColumnName(String column) {
        return String.format("%s.%s", this.DATABASE.qualifiedTableName("debezium_test"), column);
    }
}

