/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.Configuration;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogConnectorTest;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.pipeline.notification.AbstractNotificationsIT;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceConnector;
import org.junit.After;
import org.junit.Before;

public abstract class BinlogNotificationsIT<C extends SourceConnector>
extends AbstractNotificationsIT<C>
implements BinlogConnectorTest<C> {
    protected static final String SERVER_NAME = "is_test";
    protected final UniqueDatabase DATABASE = TestHelper.getUniqueDatabase("is_test", "incremental_snapshot-test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    protected static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-is.txt").toAbsolutePath();

    @Before
    public void before() throws SQLException {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    protected List<String> collections() {
        return List.of("a", "b", "c", "a4", "a42", "a_dt", "a_date", "debezium_signal").stream().map(tbl -> String.format("%s.%s", this.DATABASE.getDatabaseName(), tbl)).collect(Collectors.toList());
    }

    protected Class<C> connectorClass() {
        return this.getConnectorClass();
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, BinlogConnectorConfig.SnapshotMode.INITIAL.getValue());
    }

    protected String connector() {
        return this.getConnectorName();
    }

    protected String server() {
        return this.DATABASE.getServerName();
    }

    protected String snapshotStatusResult() {
        return "COMPLETED";
    }
}

