/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.AbstractBinlogConnectorIT;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceConnector;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class BinlogMultiTableStatementIT<C extends SourceConnector>
extends AbstractBinlogConnectorIT<C> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-json.txt").toAbsolutePath();
    private UniqueDatabase DATABASE;
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE = TestHelper.getUniqueDatabase("multitable", "multitable_dbz_871").withDbHistoryPath(SCHEMA_HISTORY_PATH);
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(this.getConnectorClass(), this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(6);
        ArrayList tableNames = new ArrayList();
        records.forEach(record -> {
            Struct source = ((Struct)record.value()).getStruct("source");
            Assertions.assertThat((String)source.getString("db")).isEqualTo((Object)this.DATABASE.getDatabaseName());
            tableNames.add(source.getString("table"));
        });
        Assertions.assertThat(tableNames.subList(0, 5)).containsExactly((Object[])new String[]{null, "t1", "t2", "t3", "t4"});
        Object[] dropTableNames = ((String)tableNames.get(5)).split(",");
        Assertions.assertThat((Object[])dropTableNames).containsOnly((Object[])new String[]{"t1", "t2", "t3", "t4"});
        this.stopConnector();
    }
}

