/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogConnectorTest;
import io.debezium.connector.binlog.junit.BinlogDatabaseVersionResolver;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.AbstractBlockingSnapshotTest;
import io.debezium.relational.TableId;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.source.SourceConnector;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Before;

public abstract class BinlogBlockingSnapshotIT<C extends SourceConnector>
extends AbstractBlockingSnapshotTest
implements BinlogConnectorTest<C> {
    protected static final String SERVER_NAME = "is_test";
    public static final int MYSQL8 = 8;
    protected final UniqueDatabase DATABASE = TestHelper.getUniqueDatabase("is_test", "blocking_snapshot_test", "1", null).withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private final BinlogDatabaseVersionResolver databaseVersionResolver = new BinlogDatabaseVersionResolver();

    @Before
    public void before() throws SQLException {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() {
        try {
            this.stopConnector();
            JdbcConnection connection = this.databaseConnection();
            connection.execute(new String[]{"drop database if exists blocking_snapshot_test_1"});
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.INCLUDE_SQL_QUERY, true)).with(BinlogConnectorConfig.USER, "mysqluser")).with(BinlogConnectorConfig.PASSWORD, "mysqlpw")).with(BinlogConnectorConfig.SNAPSHOT_MODE, BinlogConnectorConfig.SnapshotMode.NO_DATA.getValue())).with(BinlogConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(BinlogConnectorConfig.SIGNAL_DATA_COLLECTION, this.DATABASE.qualifiedTableName("debezium_signal"))).with(CommonConnectorConfig.SIGNAL_POLL_INTERVAL_MS, 1);
    }

    protected Configuration.Builder mutableConfig(boolean signalTableOnly, boolean storeOnlyCapturedDdl) {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.INCLUDE_SQL_QUERY, true)).with(BinlogConnectorConfig.USER, "mysqluser")).with(BinlogConnectorConfig.PASSWORD, "mysqlpw")).with(BinlogConnectorConfig.SNAPSHOT_MODE, BinlogConnectorConfig.SnapshotMode.INITIAL.getValue())).with(BinlogConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(BinlogConnectorConfig.SIGNAL_DATA_COLLECTION, this.DATABASE.qualifiedTableName("debezium_signal"))).with(CommonConnectorConfig.SIGNAL_POLL_INTERVAL_MS, 5)).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, storeOnlyCapturedDdl)).with(BinlogConnectorConfig.SNAPSHOT_MODE_TABLES, this.DATABASE.qualifiedTableName("a"))).with(CommonConnectorConfig.SCHEMA_NAME_ADJUSTMENT_MODE, (EnumeratedValue)CommonConnectorConfig.SchemaNameAdjustmentMode.AVRO);
    }

    protected Configuration.Builder historizedMutableConfig(boolean signalTableOnly, boolean storeOnlyCapturedDdl) {
        return (Configuration.Builder)this.mutableConfig(signalTableOnly, storeOnlyCapturedDdl).with(BinlogConnectorConfig.INCLUDE_SCHEMA_CHANGES, true);
    }

    protected String connector() {
        return this.getConnectorName();
    }

    protected String server() {
        return this.DATABASE.getServerName();
    }

    protected Class<C> connectorClass() {
        return this.getConnectorClass();
    }

    protected JdbcConnection databaseConnection() {
        return this.getTestDatabaseConnection(this.DATABASE.getDatabaseName());
    }

    protected String topicName() {
        return this.DATABASE.topicForTable("a");
    }

    protected List<String> topicNames() {
        return List.of(this.DATABASE.topicForTable("a"), this.DATABASE.topicForTable("b"));
    }

    protected String tableName() {
        return this.tableNameId().toQuotedString('`');
    }

    protected List<String> tableNames() {
        String tableA = TableId.parse((String)this.DATABASE.qualifiedTableName("a")).toQuotedString('`');
        String tableB = TableId.parse((String)this.DATABASE.qualifiedTableName("b")).toQuotedString('`');
        return List.of(tableA, tableB);
    }

    protected String signalTableName() {
        return this.tableNameId("debezium_signal").toQuotedString('`');
    }

    protected String escapedTableDataCollectionId() {
        return String.format("\\\\\"%s\\\\\".\\\\\"%s\\\\\"", this.tableNameId().catalog(), this.tableNameId().table());
    }

    protected String signalTableNameSanitized() {
        return this.DATABASE.qualifiedTableName("debezium_signal");
    }

    protected String tableDataCollectionId() {
        return this.tableNameId().toString();
    }

    protected List<String> tableDataCollectionIds() {
        return List.of(this.tableNameId().toString(), this.tableNameId("b").toString());
    }

    private TableId tableNameId() {
        return this.tableNameId("a");
    }

    private TableId tableNameId(String table) {
        return TableId.parse((String)this.DATABASE.qualifiedTableName(table));
    }

    protected int expectedDdlsCount() {
        return 12;
    }

    protected void assertDdl(List<String> schemaChangesDdls) {
        Assertions.assertThat((String)schemaChangesDdls.get(schemaChangesDdls.size() - 2)).isEqualTo((Object)"DROP TABLE IF EXISTS `blocking_snapshot_test_1`.`b`");
        Assertions.assertThat((String)schemaChangesDdls.get(schemaChangesDdls.size() - 1)).isEqualTo((Object)BinlogBlockingSnapshotIT.getDdlString(this.databaseVersionResolver));
    }

    @NotNull
    private static String getDdlString(BinlogDatabaseVersionResolver databaseVersionResolver) {
        boolean isMariaDB = databaseVersionResolver.isMariaDb();
        if (isMariaDB || databaseVersionResolver.getVersion().getMajor() < 8) {
            StringBuilder sb = new StringBuilder("CREATE TABLE `b` (\n");
            sb.append("  `pk` int(11) NOT NULL AUTO_INCREMENT,\n");
            sb.append("  `aa` int(11) DEFAULT NULL,\n");
            sb.append("  PRIMARY KEY (`pk`)\n");
            sb.append(") ENGINE=InnoDB AUTO_INCREMENT=1001 DEFAULT CHARSET=latin1");
            if (isMariaDB) {
                sb.append(" COLLATE=latin1_swedish_ci");
            }
            return sb.toString();
        }
        return "CREATE TABLE `b` (\n  `pk` int NOT NULL AUTO_INCREMENT,\n  `aa` int DEFAULT NULL,\n  PRIMARY KEY (`pk`)\n) ENGINE=InnoDB AUTO_INCREMENT=1001 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci";
    }
}

