/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.kcrestextension.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.debezium.kcrestextension.entities.PluginDefinition;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformDefinition
extends PluginDefinition {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformDefinition.class);

    @JsonCreator
    public TransformDefinition(String className, ConfigDef config) {
        super(className, config);
    }

    @JsonCreator
    public static TransformDefinition fromPluginDesc(PluginDesc<Transformation<?>> transformPlugin) {
        String className = transformPlugin.pluginClass().getName();
        if (className.endsWith("$Value")) {
            return null;
        }
        if (className.endsWith("$Key")) {
            className = className.substring(0, className.length() - 4);
        }
        LOGGER.info("Loading config for TRANSFORM: " + className + "...");
        try {
            return new TransformDefinition(className, ((Transformation)transformPlugin.pluginClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).config());
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Unable to load TRANSFORM: " + className + "\n\t Reason: " + String.valueOf(e));
            return null;
        }
    }

    @JsonProperty(value="transform")
    public String className() {
        return this.className;
    }
}

