/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal;

import io.debezium.config.CommonConnectorConfig;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.connect.data.Struct;

public class SignalRecord {
    private final String id;
    private final String type;
    private final String data;
    private final Map<String, Object> additionalData;

    public SignalRecord(String id, String type, String data, Map<String, Object> additionalData) {
        this.id = id;
        this.type = type;
        this.data = data;
        this.additionalData = additionalData;
    }

    public static Optional<SignalRecord> buildSignalRecordFromChangeEventSource(Struct value, CommonConnectorConfig config) {
        Optional<String[]> parseSignal = config.parseSignallingMessage(value);
        return parseSignal.map(signalMessage -> new SignalRecord(signalMessage[0], signalMessage[1], signalMessage[2], Map.of()));
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getData() {
        return this.data;
    }

    public <T> T getAdditionalDataProperty(String property, Class<T> type) {
        return type.cast(this.additionalData.get(property));
    }

    public Map<String, Object> getAdditionalData() {
        return this.additionalData;
    }

    public String toString() {
        return "SignalRecord{id='" + this.id + "', type='" + this.type + "', data='" + this.data + "', additionalData=" + String.valueOf(this.additionalData) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalRecord that = (SignalRecord)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

