/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.kcrestextension.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.debezium.kcrestextension.entities.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigDef;

abstract class PluginDefinition {
    protected final String className;
    protected final Map<String, PropertyDescriptor> properties;

    PluginDefinition(String className, ConfigDef config) {
        this.className = className;
        this.properties = PluginDefinition.getConfigProperties(className, config);
    }

    private static Map<String, PropertyDescriptor> getConfigProperties(String className, ConfigDef configDef) {
        HashMap<String, PropertyDescriptor> configProperties = new HashMap<String, PropertyDescriptor>();
        configDef.configKeys().forEach((fieldName, configKey) -> {
            if (null != configKey.documentation && !configKey.documentation.startsWith("Deprecated") && !configKey.internalConfig) {
                configProperties.put((String)fieldName, new PropertyDescriptor(className, (ConfigDef.ConfigKey)configKey));
            }
        });
        return configProperties;
    }

    @JsonProperty
    public Map<String, PropertyDescriptor> properties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PluginDefinition that = (PluginDefinition)o;
            return Objects.equals(this.className, that.className) && Objects.equals(this.properties, that.properties);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.className, this.properties);
    }

    public String toString() {
        return "PluginDefinition{className='" + this.className + "', documentation='" + String.valueOf(this.properties) + "'}";
    }
}

