/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.kcrestextension;

import io.debezium.kcrestextension.DebeziumConnectRestExtension;
import io.debezium.kcrestextension.DebeziumResource;
import io.debezium.kcrestextension.Module;
import io.debezium.testing.testcontainers.testhelper.RestExtensionTestInfrastructure;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumResourceIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumResourceIT.class);
    private static final List<String> SUPPORTED_TRANSFORMS = List.of("io.debezium.connector.mongodb.transforms.ExtractNewDocumentState", "io.debezium.connector.mongodb.transforms.outbox.MongoEventRouter", "io.debezium.connector.mysql.transforms.ReadToInsertEvent", "io.debezium.connector.postgresql.transforms.timescaledb.TimescaleDb", "io.debezium.transforms.ByLogicalTableRouter", "io.debezium.transforms.ContentBasedRouter", "io.debezium.transforms.ExtractChangedRecordState", "io.debezium.transforms.ExtractSchemaToNewRecord", "io.debezium.transforms.ExtractNewRecordState", "io.debezium.transforms.Filter", "io.debezium.transforms.HeaderToValue", "io.debezium.transforms.SchemaChangeEventFilter", "io.debezium.transforms.TimezoneConverter", "io.debezium.transforms.outbox.EventRouter", "io.debezium.transforms.partitions.PartitionRouting", "io.debezium.transforms.tracing.ActivateTracingSpan", "org.apache.kafka.connect.transforms.Cast", "org.apache.kafka.connect.transforms.DropHeaders", "org.apache.kafka.connect.transforms.ExtractField", "org.apache.kafka.connect.transforms.Filter", "org.apache.kafka.connect.transforms.Flatten", "org.apache.kafka.connect.transforms.HeaderFrom", "org.apache.kafka.connect.transforms.HoistField", "org.apache.kafka.connect.transforms.InsertField", "org.apache.kafka.connect.transforms.InsertHeader", "org.apache.kafka.connect.transforms.MaskField", "org.apache.kafka.connect.transforms.RegexRouter", "org.apache.kafka.connect.transforms.ReplaceField", "org.apache.kafka.connect.transforms.SetSchemaMetadata", "org.apache.kafka.connect.transforms.TimestampConverter", "org.apache.kafka.connect.transforms.TimestampRouter", "org.apache.kafka.connect.transforms.ValueToKey");
    private static final List<String> KAFKA_CONNECT_SMTs = SUPPORTED_TRANSFORMS.stream().filter(smt -> smt.startsWith("org.apache.kafka.connect.transforms.")).collect(Collectors.toList());
    private static final List<String> SUPPORTED_PREDICATES = List.of("org.apache.kafka.connect.transforms.predicates.HasHeaderKey", "org.apache.kafka.connect.transforms.predicates.RecordIsTombstone", "org.apache.kafka.connect.transforms.predicates.TopicNameMatches");

    @BeforeEach
    public void start() {
        RestExtensionTestInfrastructure.setupDebeziumContainer((String)Module.version(), (String)DebeziumConnectRestExtension.class.getName());
    }

    @AfterEach
    public void stop() {
        RestExtensionTestInfrastructure.stopContainers();
    }

    @Test
    public void testTopicCreationEndpoint() {
        RestExtensionTestInfrastructure.startContainers((RestExtensionTestInfrastructure.DATABASE)RestExtensionTestInfrastructure.DATABASE.NONE);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().get("/debezium/topic-creation-enabled", new Object[0])).then()).log().all()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
    }

    @Test
    public void testTopicCreationEndpointWhenExplicitlyDisabled() {
        RestExtensionTestInfrastructure.getDebeziumContainer().withEnv("CONNECT_TOPIC_CREATION_ENABLE", "false");
        RestExtensionTestInfrastructure.startContainers((RestExtensionTestInfrastructure.DATABASE)RestExtensionTestInfrastructure.DATABASE.NONE);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().get("/debezium/topic-creation-enabled", new Object[0])).then()).log().all()).statusCode(200)).body(Matchers.is((Object)"false"), new Matcher[0]);
    }

    @Test
    @Disabled(value="See DBZ-7416 https://issues.redhat.com/browse/DBZ-7416")
    public void testTransformsEndpoint() {
        RestExtensionTestInfrastructure.startContainers((RestExtensionTestInfrastructure.DATABASE)RestExtensionTestInfrastructure.DATABASE.NONE);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().get("/debezium/transforms", new Object[0])).then()).log().all()).statusCode(200)).body("transform.size()", Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(KAFKA_CONNECT_SMTs.size())), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(SUPPORTED_TRANSFORMS.size() + 1))), new Object[0])).body("transform", Matchers.containsInRelativeOrder((Object[])KAFKA_CONNECT_SMTs.toArray()), new Object[0])).body("transform", Matchers.containsInAnyOrder((Object[])SUPPORTED_TRANSFORMS.toArray()), new Object[0]);
    }

    @Test
    public void testPredicatesEndpoint() {
        RestExtensionTestInfrastructure.startContainers((RestExtensionTestInfrastructure.DATABASE)RestExtensionTestInfrastructure.DATABASE.NONE);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().get("/debezium/predicates", new Object[0])).then()).log().all()).statusCode(200)).body("predicate.size()", Matchers.is((Object)SUPPORTED_PREDICATES.size()), new Object[0])).body("predicate", Matchers.containsInAnyOrder((Object[])SUPPORTED_PREDICATES.toArray()), new Object[0]);
    }

    @Test
    public void testConnectorPluginsEndpoint() {
        RestExtensionTestInfrastructure.startContainers((RestExtensionTestInfrastructure.DATABASE)RestExtensionTestInfrastructure.DATABASE.NONE);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().get("/debezium/connector-plugins", new Object[0])).then()).log().all()).statusCode(200)).body("size()", Matchers.is((Object)DebeziumResource.SUPPORTED_CONNECTORS.size()), new Object[0])).body("className", Matchers.containsInAnyOrder((Object[])DebeziumResource.SUPPORTED_CONNECTORS.toArray()), new Object[0]);
    }
}

