/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.kcrestextension;

import io.debezium.DebeziumException;
import io.debezium.kcrestextension.Module;
import io.debezium.kcrestextension.entities.PredicateDefinition;
import io.debezium.kcrestextension.entities.TransformDefinition;
import io.debezium.metadata.ConnectorDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.health.ConnectClusterState;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;

@Path(value="/debezium")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DebeziumResource {
    public static final String BASE_PATH = "/debezium";
    public static final String CONNECTOR_PLUGINS_ENDPOINT = "/connector-plugins";
    public static final String TRANSFORMS_ENDPOINT = "/transforms";
    public static final String PREDICATES_ENDPOINT = "/predicates";
    public static final String TOPIC_CREATION_ENDPOINT = "/topic-creation-enabled";
    public static final Set<String> SUPPORTED_CONNECTORS = new HashSet<String>(Arrays.asList("io.debezium.connector.mongodb.MongoDbConnector", "io.debezium.connector.mysql.MySqlConnector", "io.debezium.connector.oracle.OracleConnector", "io.debezium.connector.postgresql.PostgresConnector", "io.debezium.connector.sqlserver.SqlServerConnector"));
    private final ConnectClusterState connectClusterState;
    private Herder herder = null;
    private final Boolean isTopicCreationEnabled;
    private List<TransformDefinition> transforms = null;
    private List<PredicateDefinition> predicates = null;
    private List<ConnectorDescriptor> availableConnectorPlugins = null;
    private static final Pattern VERSION_PATTERN = Pattern.compile("([1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)(?:-([a-zA-Z0-9]+))?(?:(\\+)(0|[1-9][0-9]*)?)?(?:-([-a-zA-Z0-9.]+))?");
    private static final Runtime.Version TOPIC_CREATION_KAFKA_VERSION = DebeziumResource.parseVersion("2.6.0");
    @Context
    private ServletContext context;

    public DebeziumResource(ConnectClusterState connectClusterState, Map<String, ?> config) {
        this.connectClusterState = connectClusterState;
        this.isTopicCreationEnabled = this.isTopicCreationEnabled(config);
    }

    public static Runtime.Version parseVersion(String version) {
        Matcher m = VERSION_PATTERN.matcher(version);
        if (m.matches()) {
            return Runtime.Version.parse(version);
        }
        if (m.lookingAt()) {
            return Runtime.Version.parse(m.group());
        }
        throw new IllegalArgumentException("Invalid version string: \"" + version + "\"");
    }

    private static <T> void addConnectorPlugins(Map<String, ConnectorDescriptor> connectorPlugins, Collection<PluginDesc<T>> plugins) {
        plugins.stream().filter(p -> SUPPORTED_CONNECTORS.contains(p.pluginClass().getName())).forEach(p -> connectorPlugins.put(p.pluginClass().getName() + "#" + p.version(), new ConnectorDescriptor(p.pluginClass().getName(), p.version())));
    }

    private synchronized void initConnectorPlugins() {
        if (null == this.availableConnectorPlugins || this.availableConnectorPlugins.isEmpty()) {
            HashMap<String, ConnectorDescriptor> connectorPlugins = new HashMap<String, ConnectorDescriptor>();
            Herder herder = this.getHerder();
            DebeziumResource.addConnectorPlugins(connectorPlugins, herder.plugins().sinkConnectors());
            DebeziumResource.addConnectorPlugins(connectorPlugins, herder.plugins().sourceConnectors());
            this.availableConnectorPlugins = Collections.unmodifiableList(new ArrayList(connectorPlugins.values()));
        }
    }

    private synchronized void initTransformsAndPredicates() {
        if (null == this.transforms || this.transforms.isEmpty()) {
            ArrayList<TransformDefinition> transformPlugins = new ArrayList<TransformDefinition>();
            ArrayList<PredicateDefinition> predicatePlugins = new ArrayList<PredicateDefinition>();
            Herder herder = this.getHerder();
            for (PluginDesc transformPlugin : herder.plugins().transformations()) {
                TransformDefinition transformDefinition = TransformDefinition.fromPluginDesc(transformPlugin);
                if (null == transformDefinition) continue;
                transformPlugins.add(transformDefinition);
            }
            for (PluginDesc predicate : herder.plugins().predicates()) {
                PredicateDefinition predicateDefinition = PredicateDefinition.fromPluginDesc(predicate);
                if (null == predicateDefinition) continue;
                predicatePlugins.add(predicateDefinition);
            }
            this.predicates = Collections.unmodifiableList(predicatePlugins);
            this.transforms = Collections.unmodifiableList(transformPlugins);
        }
    }

    private synchronized Boolean isTopicCreationEnabled(Map<String, ?> config) {
        Runtime.Version kafkaConnectVersion = DebeziumResource.parseVersion(AppInfoParser.getVersion());
        String topicCreationProperty = (String)config.get("topic.creation.enable");
        if (null == topicCreationProperty) {
            topicCreationProperty = "true";
        }
        return TOPIC_CREATION_KAFKA_VERSION.compareTo(kafkaConnectVersion) <= 0 && Boolean.parseBoolean(topicCreationProperty);
    }

    private synchronized Herder getHerder() {
        if (null == this.herder) {
            Field herderField;
            try {
                herderField = this.connectClusterState.getClass().getDeclaredField("herder");
            }
            catch (NoSuchFieldException e) {
                throw new DebeziumException((Throwable)e);
            }
            herderField.setAccessible(true);
            try {
                this.herder = (Herder)herderField.get(this.connectClusterState);
            }
            catch (IllegalAccessException e) {
                throw new DebeziumException((Throwable)e);
            }
        }
        return this.herder;
    }

    @GET
    @Path(value="/connector-plugins")
    @Produces(value={"application/json"})
    public List<ConnectorDescriptor> availableDebeziumConnectors() {
        this.initConnectorPlugins();
        return this.availableConnectorPlugins;
    }

    @GET
    @Path(value="/transforms")
    @Produces(value={"application/json"})
    public List<TransformDefinition> listTransforms() {
        this.initTransformsAndPredicates();
        return this.transforms;
    }

    @GET
    @Path(value="/predicates")
    @Produces(value={"application/json"})
    public List<PredicateDefinition> listPredicates() {
        this.initTransformsAndPredicates();
        return this.predicates;
    }

    @GET
    @Path(value="/topic-creation-enabled")
    @Produces(value={"application/json"})
    public boolean getTopicCreationEnabled() {
        return this.isTopicCreationEnabled;
    }

    @GET
    @Path(value="/version")
    @Produces(value={"application/json"})
    public String getDebeziumVersion() {
        return Module.version();
    }
}

