/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.kcrestextension.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.debezium.kcrestextension.entities.PluginDefinition;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.transforms.predicates.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateDefinition
extends PluginDefinition {
    private static final Logger LOGGER = LoggerFactory.getLogger(PredicateDefinition.class);

    @JsonCreator
    public PredicateDefinition(String className, ConfigDef config) {
        super(className, config);
    }

    @JsonCreator
    public static PredicateDefinition fromPluginDesc(PluginDesc<Predicate<?>> predicate) {
        String className = predicate.pluginClass().getName();
        LOGGER.info("Loading config for PREDICATE: " + className + "...");
        try {
            return new PredicateDefinition(className, ((Predicate)predicate.pluginClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).config());
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Unable to load PREDICATE: " + className + "\n\t Reason: " + e);
            return null;
        }
    }

    @JsonProperty(value="predicate")
    public String className() {
        return this.className;
    }
}

