/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.kcrestextension;

import io.debezium.testing.testcontainers.DebeziumContainer;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.lifecycle.Startables;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class TestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestHelper.class);
    private static final String KAFKA_HOSTNAME = "kafka-dbz-ui";
    public static final String API_PREFIX = "/debezium";
    public static final String TRANSFORMS_ENDPOINT = "/transforms";
    public static final String TOPIC_CREATION_ENDPOINT = "/topic-creation";
    private static final Network NETWORK = Network.newNetwork();
    private static final KafkaContainer KAFKA_CONTAINER = (KafkaContainer)((KafkaContainer)new KafkaContainer(DockerImageName.parse((String)"confluentinc/cp-kafka:5.4.5")).withNetworkAliases(new String[]{"kafka-dbz-ui"})).withNetwork(NETWORK);
    private static DebeziumContainer DEBEZIUM_CONTAINER;

    public static DebeziumContainer getDebeziumContainer() {
        return DEBEZIUM_CONTAINER;
    }

    public static void setupDebeziumContainer(String debeziumVersion) {
        DEBEZIUM_CONTAINER = (DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)new DebeziumContainer(DockerImageName.parse((String)("debezium/connect:" + debeziumVersion))).withEnv("ENABLE_DEBEZIUM_SCRIPTING", "true")).withEnv("CONNECT_REST_EXTENSION_CLASSES", "io.debezium.kcrestextension.DebeziumConnectRestExtension")).withNetwork(NETWORK)).withCopyFileToContainer(MountableFile.forHostPath((String)"target/debezium-connect-rest-extension-1.8.0-SNAPSHOT.jar"), "/kafka/libs/debezium-kcd-rest-extension-1.8.0.jar")).withKafka(KAFKA_CONTAINER.getNetwork(), "kafka-dbz-ui:9092").withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER))).withStartupTimeout(Duration.ofSeconds(90L))).dependsOn(new Startable[]{KAFKA_CONTAINER});
    }

    public static void withEnv(String key, String value) {
        DEBEZIUM_CONTAINER = (DebeziumContainer)DEBEZIUM_CONTAINER.withEnv(key, value);
    }

    public static void startContainers() {
        Startables.deepStart(Stream.of(KAFKA_CONTAINER, DEBEZIUM_CONTAINER)).join();
    }

    public static void stopContainers() {
        try {
            if (DEBEZIUM_CONTAINER != null) {
                DEBEZIUM_CONTAINER.stop();
            }
            if (KAFKA_CONTAINER != null) {
                KAFKA_CONTAINER.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

