/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.kcrestextension;

import io.debezium.kcrestextension.TestHelper;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumResourceIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumResourceIT.class);
    private static final String DEBEZIUM_VERSION = "1.7";

    @BeforeEach
    public void start() {
        TestHelper.stopContainers();
        TestHelper.setupDebeziumContainer(DEBEZIUM_VERSION);
    }

    @AfterEach
    public void stop() {
        TestHelper.stopContainers();
    }

    @Test
    public void testTopicCreationEndpoint() {
        TestHelper.startContainers();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(TestHelper.getDebeziumContainer().getFirstMappedPort().intValue()).when().get("/debezium/topic-creation", new Object[0])).then()).log().all()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
    }

    @Test
    public void testTopicCreationEndpointWhenExplicitlyDisabled() {
        TestHelper.withEnv("CONNECT_TOPIC_CREATION_ENABLE", "false");
        TestHelper.startContainers();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(TestHelper.getDebeziumContainer().getFirstMappedPort().intValue()).when().get("/debezium/topic-creation", new Object[0])).then()).log().all()).statusCode(200)).body(Matchers.is((Object)"false"), new Matcher[0]);
    }

    @Test
    public void testTransformsEndpoint() {
        TestHelper.startContainers();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(TestHelper.getDebeziumContainer().getFirstMappedPort().intValue()).when().get("/debezium/transforms", new Object[0])).then()).log().all()).statusCode(200)).body("transform.size()", Matchers.is((Object)33), new Object[0])).body("transform", Matchers.containsInAnyOrder((Object[])List.of("io.debezium.connector.mongodb.transforms.ExtractNewDocumentState", "io.debezium.connector.mysql.transforms.ReadToInsertEvent", "io.debezium.transforms.ByLogicalTableRouter", "io.debezium.transforms.ContentBasedRouter", "io.debezium.transforms.ExtractNewRecordState", "io.debezium.transforms.Filter", "io.debezium.transforms.outbox.EventRouter", "io.debezium.transforms.tracing.ActivateTracingSpan", "org.apache.kafka.connect.transforms.predicates.HasHeaderKey", "org.apache.kafka.connect.transforms.predicates.RecordIsTombstone", "org.apache.kafka.connect.transforms.predicates.TopicNameMatches", "org.apache.kafka.connect.transforms.Cast$Key", "org.apache.kafka.connect.transforms.Cast$Value", "org.apache.kafka.connect.transforms.ExtractField$Key", "org.apache.kafka.connect.transforms.ExtractField$Value", "org.apache.kafka.connect.transforms.Filter", "org.apache.kafka.connect.transforms.Flatten$Key", "org.apache.kafka.connect.transforms.Flatten$Value", "org.apache.kafka.connect.transforms.HoistField$Key", "org.apache.kafka.connect.transforms.HoistField$Value", "org.apache.kafka.connect.transforms.InsertField$Key", "org.apache.kafka.connect.transforms.InsertField$Value", "org.apache.kafka.connect.transforms.MaskField$Key", "org.apache.kafka.connect.transforms.MaskField$Value", "org.apache.kafka.connect.transforms.RegexRouter", "org.apache.kafka.connect.transforms.ReplaceField$Key", "org.apache.kafka.connect.transforms.ReplaceField$Value", "org.apache.kafka.connect.transforms.SetSchemaMetadata$Key", "org.apache.kafka.connect.transforms.SetSchemaMetadata$Value", "org.apache.kafka.connect.transforms.TimestampConverter$Key", "org.apache.kafka.connect.transforms.TimestampConverter$Value", "org.apache.kafka.connect.transforms.TimestampRouter", "org.apache.kafka.connect.transforms.ValueToKey").toArray()), new Object[0]);
    }
}

