/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.kcrestextension;

import io.debezium.kcrestextension.entities.TransformsInfo;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.health.ConnectClusterState;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.health.ConnectClusterStateImpl;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.transforms.predicates.HasHeaderKey;
import org.apache.kafka.connect.transforms.predicates.RecordIsTombstone;
import org.apache.kafka.connect.transforms.predicates.TopicNameMatches;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/debezium")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DebeziumResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumResource.class);
    public static final Duration REQUEST_TIMEOUT_MS;
    private static Duration requestTimeoutMs;
    private final List<TransformsInfo> transforms;
    private final Boolean isTopicCreationEnabled;
    private final Herder herder;
    private final Map<String, ?> config;
    private static final Pattern VERSION_PATTERN;
    private static final Runtime.Version TOPIC_CREATION_KAFKA_VERSION;
    @Context
    private ServletContext context;

    public DebeziumResource(ConnectClusterState clusterState, Map<String, ?> config) {
        Field herderField;
        try {
            herderField = ConnectClusterStateImpl.class.getDeclaredField("herder");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        herderField.setAccessible(true);
        try {
            this.herder = (Herder)herderField.get(clusterState);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.transforms = new ArrayList<TransformsInfo>();
        this.config = config;
        this.isTopicCreationEnabled = this.isTopicCreationEnabled();
    }

    public static void setRequestTimeout(long requestTimeoutMs) {
        DebeziumResource.requestTimeoutMs = Duration.ofMillis(requestTimeoutMs);
    }

    public static Runtime.Version parseVersion(String version) {
        Matcher m = VERSION_PATTERN.matcher(version);
        if (m.matches()) {
            return Runtime.Version.parse(version);
        }
        if (m.lookingAt()) {
            return Runtime.Version.parse(m.group());
        }
        throw new IllegalArgumentException("Invalid version string: \"" + version + "\"");
    }

    public static void resetRequestTimeout() {
        requestTimeoutMs = REQUEST_TIMEOUT_MS;
    }

    @GET
    @Path(value="/transforms")
    public List<TransformsInfo> listTransforms() {
        return this.getTransforms();
    }

    private synchronized List<TransformsInfo> getTransforms() {
        if (this.transforms.isEmpty()) {
            for (PluginDesc plugin : this.herder.plugins().transformations()) {
                if ("org.apache.kafka.connect.runtime.PredicatedTransformation".equals(plugin.className())) {
                    this.transforms.add(new TransformsInfo(HasHeaderKey.class.getName(), new HasHeaderKey().config()));
                    this.transforms.add(new TransformsInfo(RecordIsTombstone.class.getName(), new RecordIsTombstone().config()));
                    this.transforms.add(new TransformsInfo(TopicNameMatches.class.getName(), new TopicNameMatches().config()));
                    continue;
                }
                this.transforms.add(new TransformsInfo(plugin));
            }
        }
        return Collections.unmodifiableList(this.transforms);
    }

    @GET
    @Path(value="/topic-creation")
    public boolean getTopicCreationEnabled() {
        return this.isTopicCreationEnabled;
    }

    private synchronized Boolean isTopicCreationEnabled() {
        Runtime.Version kafkaConnectVersion = DebeziumResource.parseVersion(AppInfoParser.getVersion());
        String topicCreationProperty = (String)this.config.get("topic.creation.enable");
        if (null == topicCreationProperty) {
            topicCreationProperty = "true";
        }
        return TOPIC_CREATION_KAFKA_VERSION.compareTo(kafkaConnectVersion) <= 0 && Boolean.parseBoolean(topicCreationProperty);
    }

    static {
        requestTimeoutMs = REQUEST_TIMEOUT_MS = Duration.ofSeconds(90L);
        VERSION_PATTERN = Pattern.compile("([1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)(?:-([a-zA-Z0-9]+))?(?:(\\+)(0|[1-9][0-9]*)?)?(?:-([-a-zA-Z0-9.]+))?");
        TOPIC_CREATION_KAFKA_VERSION = DebeziumResource.parseVersion("2.6.0");
    }
}

