/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.checkstyle;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.imports.UnusedImportsCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import io.debezium.checkstyle.JavaDocUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnusedImports
extends UnusedImportsCheck {
    private static final String[] DEBUG_CLASSNAMES = new String[0];
    private static final Set<String> DEBUG_CLASSNAMES_SET = new HashSet<String>(Arrays.asList(DEBUG_CLASSNAMES));
    private static final Pattern LINK_VALUE_IN_TEXT_PATTERN = CommonUtil.createPattern((String)"(.*?)(?:\\s+|#|\\$)(.*)");
    private static final Pattern PARTS_OF_CLASS_OR_REFERENCE_PATTERN = CommonUtil.createPattern((String)"([\\w.]+)(?:\\#?\\w+)?(?:\\(([^\\)]+)\\))?.*");
    private static final Pattern LINK_VALUE_PATTERN = CommonUtil.createPattern((String)"\\{\\@link\\s+([^}]*)");
    private boolean collect = false;
    private boolean processJavaDoc = false;
    private final Set<FullIdent> imports = new HashSet<FullIdent>();
    private final Set<String> referenced = new HashSet<String>();
    private boolean print = false;

    public void setProcessJavadoc(boolean aValue) {
        super.setProcessJavadoc(aValue);
        this.processJavaDoc = aValue;
    }

    public void beginTree(DetailAST aRootAST) {
        this.collect = false;
        this.imports.clear();
        this.referenced.clear();
        super.beginTree(aRootAST);
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 14) {
            String classname = aAST.findFirstToken(58).getText();
            this.print = DEBUG_CLASSNAMES_SET.contains(classname);
        }
        if (aAST.getType() == 58) {
            super.visitToken(aAST);
            if (this.collect) {
                this.processIdent(aAST);
            }
        } else if (aAST.getType() == 30) {
            super.visitToken(aAST);
            this.processImport(aAST);
        } else if (aAST.getType() == 152) {
            super.visitToken(aAST);
            this.processStaticImport(aAST);
        } else {
            this.collect = true;
            if (this.processJavaDoc) {
                this.processJavaDocLinkParameters(aAST);
                super.visitToken(aAST);
            }
        }
    }

    protected void processIdent(DetailAST aAST) {
        int parentType = aAST.getParent().getType();
        if (parentType != 59 && parentType != 9 || parentType == 59 && aAST.getNextSibling() != null) {
            this.referenced.add(aAST.getText());
        }
    }

    protected void processJavaDocLinkParameters(DetailAST aAST) {
        int lineNo;
        FileContents contents = this.getFileContents();
        TextBlock cmt = contents.getJavadocBefore(lineNo = aAST.getLineNo());
        if (cmt != null) {
            JavadocTags tags = JavaDocUtil.getJavadocTags(cmt, JavadocUtil.JavadocTagType.ALL);
            for (JavadocTag tag : tags.getValidTags()) {
                this.processJavaDocTag(tag);
            }
            for (JavadocTag tag : tags.getInvalidTags()) {
                this.log(tag.getLine(), tag.getCol(), "import.invalidJavaDocTag", new Object[]{tag.getName()});
            }
        }
    }

    protected void processJavaDocTag(JavadocTag tag) {
        block4: {
            block5: {
                block3: {
                    this.print("tag: ", tag);
                    if (!tag.canReferenceImports()) break block3;
                    String identifier = tag.getFirstArg();
                    this.print("Found identifier: ", identifier);
                    this.referenced.add(identifier);
                    Matcher matcher = LINK_VALUE_IN_TEXT_PATTERN.matcher(identifier);
                    while (matcher.find()) {
                        identifier = matcher.group(1);
                        this.referenced.add(identifier);
                        this.print("Found new identifier: ", identifier);
                        String methodCall = matcher.group(2);
                        this.processClassOrMethodReference(methodCall);
                    }
                    break block4;
                }
                if (!tag.isParamTag()) break block5;
                String paramText = tag.getFirstArg();
                this.print("Found parameter text: ", paramText);
                Matcher paramsMatcher = LINK_VALUE_PATTERN.matcher(paramText);
                while (paramsMatcher.find()) {
                    String linkValue = paramsMatcher.group(1);
                    this.processClassOrMethodReference(linkValue);
                }
                break block4;
            }
            if (!tag.isReturnTag()) break block4;
            String returnText = tag.getFirstArg();
            this.print("Found return text: ", returnText);
            Matcher paramsMatcher = LINK_VALUE_PATTERN.matcher(returnText);
            while (paramsMatcher.find()) {
                String linkValue = paramsMatcher.group(1);
                this.processClassOrMethodReference(linkValue);
            }
        }
    }

    protected void processClassOrMethodReference(String text) {
        this.print("Adding referenced: ", text);
        this.referenced.add(text);
        Matcher paramsMatcher = PARTS_OF_CLASS_OR_REFERENCE_PATTERN.matcher(text);
        while (paramsMatcher.find()) {
            String clazz = paramsMatcher.group(1);
            String params = paramsMatcher.group(2);
            if (clazz != null) {
                this.print("Found class: ", clazz);
                this.referenced.add(clazz);
            }
            if (params == null) continue;
            this.print("Found params: ", params);
            for (String param : params.split(",")) {
                if ("...".equals(param)) continue;
                param = param.replace("...", "").trim();
                this.print("Found param: ", param);
                this.referenced.add(param);
            }
        }
    }

    private void processImport(DetailAST aAST) {
        FullIdent name = FullIdent.createFullIdentBelow((DetailAST)aAST);
        if (name != null && !name.getText().endsWith(".*")) {
            this.imports.add(name);
        }
    }

    private void processStaticImport(DetailAST aAST) {
        FullIdent name = FullIdent.createFullIdent((DetailAST)aAST.getFirstChild().getNextSibling());
        if (name != null && !name.getText().endsWith(".*")) {
            this.imports.add(name);
        }
    }

    public void finishTree(DetailAST aRootAST) {
        for (FullIdent imp : this.imports) {
            if (this.referenced.contains(CommonUtil.baseClassName((String)imp.getText()))) continue;
            this.print("imp.getText(): " + CommonUtil.baseClassName((String)imp.getText()));
            this.print("referenced: " + this.referenced);
            this.log(imp.getLineNo(), imp.getColumnNo(), "import.unused", new Object[]{imp.getText()});
        }
    }

    private void print(Object ... messages) {
        if (this.print) {
            for (Object msg : messages) {
                System.out.print(msg);
            }
            System.out.println();
        }
    }
}

