/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.spi;

import io.debezium.spi.converter.ConvertedField;
import io.debezium.spi.converter.CustomConverter;
import java.util.Properties;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ValueConverterTest {
    final CustomConverter<SchemaBuilder, BasicField> testConverter = new CustomConverter<SchemaBuilder, BasicField>(){
        private String convertedField = "myfield";

        public void configure(Properties props) {
            this.convertedField = props.getProperty("field", this.convertedField);
        }

        public void converterFor(BasicField field, CustomConverter.ConverterRegistration<SchemaBuilder> registration) {
            if (this.convertedField.equals(field.name())) {
                registration.register((Object)SchemaBuilder.string().name("CUSTOM_STRING").optional(), x -> {
                    if (x instanceof Integer) {
                        return Integer.toString((Integer)x);
                    }
                    return x.toString();
                });
            }
        }
    };
    private TestRegistration testRegistration;

    @Before
    public void before() {
        this.testRegistration = new TestRegistration();
    }

    @Test
    public void matchingField() {
        this.testConverter.configure(new Properties());
        this.testConverter.converterFor((ConvertedField)new BasicField("myfield", "db1.table1", "VARCHAR2(30)"), (CustomConverter.ConverterRegistration)this.testRegistration);
        Assertions.assertThat((String)this.testRegistration.fieldSchema.name()).isEqualTo((Object)"CUSTOM_STRING");
        Assertions.assertThat((Object)this.testRegistration.converter.convert((Object)34)).isEqualTo((Object)"34");
    }

    @Test
    public void nonMatchingField() {
        this.testConverter.configure(new Properties());
        this.testConverter.converterFor((ConvertedField)new BasicField("wrongfield", "db1.table1", "VARCHAR2(30)"), (CustomConverter.ConverterRegistration)this.testRegistration);
        Assertions.assertThat((Object)this.testRegistration.fieldSchema).isNull();
    }

    @Test
    public void configuredField() {
        Properties props = new Properties();
        props.setProperty("field", "otherfield");
        this.testConverter.configure(props);
        this.testConverter.converterFor((ConvertedField)new BasicField("myfield", "db1.table1", "VARCHAR2(30)"), (CustomConverter.ConverterRegistration)this.testRegistration);
        Assertions.assertThat((Object)this.testRegistration.fieldSchema).isNull();
        this.testConverter.converterFor((ConvertedField)new BasicField("otherfield", "db1.table1", "VARCHAR2(30)"), (CustomConverter.ConverterRegistration)this.testRegistration);
        Assertions.assertThat((String)this.testRegistration.fieldSchema.name()).isEqualTo((Object)"CUSTOM_STRING");
        Assertions.assertThat((Object)this.testRegistration.converter.convert((Object)34)).isEqualTo((Object)"34");
    }

    private static class TestRegistration
    implements CustomConverter.ConverterRegistration<SchemaBuilder> {
        public SchemaBuilder fieldSchema;
        public CustomConverter.Converter converter;

        private TestRegistration() {
        }

        public void register(SchemaBuilder fieldSchema, CustomConverter.Converter converter) {
            this.fieldSchema = fieldSchema;
            this.converter = converter;
        }
    }

    public static class BasicField
    implements ConvertedField {
        private final String name;
        private final String dataCollection;
        private final String type;

        public BasicField(String name, String dataCollection, String type) {
            this.name = name;
            this.dataCollection = dataCollection;
            this.type = type;
        }

        public String name() {
            return this.name;
        }

        public String dataCollection() {
            return this.dataCollection;
        }

        public String type() {
            return this.type;
        }
    }
}

