/*
 * Decompiled with CFR 0.152.
 */
package io.dataspray.aws.cdk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.dataspray.aws.cdk.AbstractCdkMojo;
import io.dataspray.aws.cdk.CdkException;
import io.dataspray.aws.cdk.DeployMojo;
import io.dataspray.aws.cdk.EnvironmentResolver;
import io.dataspray.aws.cdk.ResolvedEnvironment;
import io.dataspray.aws.cdk.context.AmiContextProviderMapper;
import io.dataspray.aws.cdk.context.AvailabilityZonesContextProviderMapper;
import io.dataspray.aws.cdk.context.AwsClientProvider;
import io.dataspray.aws.cdk.context.AwsClientProviderBuilder;
import io.dataspray.aws.cdk.context.ContextProviderMapper;
import io.dataspray.aws.cdk.context.HostedZoneContextProviderMapper;
import io.dataspray.aws.cdk.context.SsmContextProviderMapper;
import io.dataspray.aws.cdk.context.VpcNetworkContextProviderMapper;
import io.dataspray.aws.cdk.node.NodeClient;
import io.dataspray.aws.cdk.node.NodeInstallationException;
import io.dataspray.aws.cdk.node.NodeInstaller;
import io.dataspray.aws.cdk.node.NodeVersion;
import io.dataspray.aws.cdk.node.UnixNodeInstaller;
import io.dataspray.aws.cdk.node.WindowsNodeInstaller;
import io.dataspray.aws.cdk.process.DefaultProcessRunner;
import io.dataspray.aws.cdk.process.ProcessContext;
import io.dataspray.aws.cdk.process.ProcessExecutionException;
import io.dataspray.aws.cdk.process.ProcessRunner;
import io.dataspray.aws.cdk.runtime.Synthesizer;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awscdk.cloudassembly.schema.AssemblyManifest;
import software.amazon.awscdk.cloudassembly.schema.ContextProvider;
import software.amazon.awscdk.cloudassembly.schema.Manifest;
import software.amazon.awscdk.cloudassembly.schema.MissingContext;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.Route53ClientBuilder;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.UnsafeCast;

@Mojo(name="synth", instantiationStrategy=InstantiationStrategy.PER_LOOKUP, defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class SynthMojo
extends AbstractCdkMojo
implements ContextEnabled {
    private static final Logger logger = LoggerFactory.getLogger(DeployMojo.class);
    private static final String CDK_CONTEXT_FILE_NAME = "cdk.context.json";
    private static final NodeVersion MINIMUM_REQUIRED_NODE_VERSION = NodeVersion.of((int)18, (int)0, (int)0);
    private static final NodeVersion INSTALLED_NODE_VERSION = NodeVersion.of((int)18, (int)16, (int)1);
    private static final String OUTPUT_DIRECTORY_VARIABLE_NAME = "CDK_OUTDIR";
    private static final String DEFAULT_ACCOUNT_VARIABLE_NAME = "CDK_DEFAULT_ACCOUNT";
    private static final String DEFAULT_REGION_VARIABLE_NAME = "CDK_DEFAULT_REGION";
    private static final String CONTEXT_VARIABLE_NAME = "CDK_CONTEXT_JSON";
    private static final String PATH_VARIABLE_NAME = "PATH";
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${settings.localRepository}", readonly=true)
    private File localRepositoryDirectory;
    @Parameter(property="aws.cdk.app", required=true)
    private String app;
    @Parameter(property="aws.cdk.arguments")
    private List<String> arguments;
    private ProcessRunner processRunner;
    private Map<ContextProvider, ContextProviderMapper<?>> contextProviders;

    @Override
    public void execute(Path cloudAssemblyDirectory, Optional<String> profileOpt) {
        EnvironmentResolver environmentResolver = EnvironmentResolver.create((String)profileOpt.orElse(null));
        this.processRunner = new DefaultProcessRunner(this.project.getBasedir());
        this.contextProviders = this.initContextProviders(environmentResolver);
        this.synthesize(this.app, this.arguments != null ? this.arguments : Collections.emptyList(), cloudAssemblyDirectory, environmentResolver);
    }

    private Map<ContextProvider, ContextProviderMapper<?>> initContextProviders(EnvironmentResolver environmentResolver) {
        AwsClientProvider awsClientProvider = new AwsClientProviderBuilder().withClientFactory(Ec2Client.class, env -> (Ec2Client)this.buildClient(Ec2Client.builder(), environmentResolver.resolve(env))).withClientFactory(SsmClient.class, env -> (SsmClient)this.buildClient(SsmClient.builder(), environmentResolver.resolve(env))).withClientFactory(Route53Client.class, env -> {
            ResolvedEnvironment resolvedEnvironment = environmentResolver.resolve(env);
            return (Route53Client)((Route53ClientBuilder)((Route53ClientBuilder)Route53Client.builder().region(Region.AWS_GLOBAL)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)resolvedEnvironment.getCredentials()))).build();
        }).build();
        HashMap contextProviders = new HashMap();
        contextProviders.put(ContextProvider.AVAILABILITY_ZONE_PROVIDER, (ContextProviderMapper<?>)new AvailabilityZonesContextProviderMapper(awsClientProvider));
        contextProviders.put(ContextProvider.SSM_PARAMETER_PROVIDER, (ContextProviderMapper<?>)new SsmContextProviderMapper(awsClientProvider));
        contextProviders.put(ContextProvider.HOSTED_ZONE_PROVIDER, (ContextProviderMapper<?>)new HostedZoneContextProviderMapper(awsClientProvider));
        contextProviders.put(ContextProvider.VPC_PROVIDER, (ContextProviderMapper<?>)new VpcNetworkContextProviderMapper(awsClientProvider));
        contextProviders.put(ContextProvider.AMI_PROVIDER, (ContextProviderMapper<?>)new AmiContextProviderMapper(awsClientProvider));
        return contextProviders;
    }

    private <B extends AwsClientBuilder<B, C>, C> C buildClient(B builder, ResolvedEnvironment environment) {
        return (C)builder.region(environment.getRegion()).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)environment.getCredentials())).build();
    }

    protected AssemblyManifest synthesize(String app, List<String> arguments, Path outputDirectory, EnvironmentResolver environmentResolver) {
        Map<String, String> environment = SystemUtils.IS_OS_WINDOWS ? System.getenv().entrySet().stream().map(variable -> Pair.of((Object)((String)variable.getKey()).toUpperCase(), (Object)((String)variable.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : new HashMap<String, String>(System.getenv());
        NodeVersion nodeVersion = this.getInstalledNodeVersion().orElse(null);
        if (nodeVersion == null || nodeVersion.compareTo(MINIMUM_REQUIRED_NODE_VERSION) < 0) {
            if (nodeVersion == null) {
                logger.info("Node.js is not installed. Using Node.js from local Maven repository");
            } else {
                logger.info("The minimum required version of Node.js is {}, however {} is installed. Using the Node.js from the local Maven repository", (Object)MINIMUM_REQUIRED_NODE_VERSION, (Object)nodeVersion);
            }
            NodeClient node = this.getNodeInstaller().install(INSTALLED_NODE_VERSION);
            environment.compute(PATH_VARIABLE_NAME, (name, path) -> Stream.of(node.getPath().toString(), path).filter(Objects::nonNull).collect(Collectors.joining(File.pathSeparator)));
        } else {
            logger.info("Using Node.js from path with version {}", (Object)nodeVersion);
        }
        environment.computeIfAbsent(OUTPUT_DIRECTORY_VARIABLE_NAME, v -> outputDirectory.toString());
        environment.computeIfAbsent(DEFAULT_REGION_VARIABLE_NAME, v -> environmentResolver.getDefaultRegion().id());
        if (environmentResolver.getDefaultAccount() != null) {
            environment.computeIfAbsent(DEFAULT_ACCOUNT_VARIABLE_NAME, v -> environmentResolver.getDefaultAccount());
        }
        HashMap context = this.readContext();
        logger.info("Synthesizing the cloud assembly for the '{}' application", (Object)app);
        AssemblyManifest cloudManifest = this.synthesize(app, arguments, outputDirectory, environment, context);
        boolean contextIsEmpty = true;
        while (cloudManifest.getMissing() != null && !cloudManifest.getMissing().isEmpty()) {
            context = Maps.newHashMap(context);
            for (MissingContext missingContext : cloudManifest.getMissing()) {
                Object contextValue;
                ContextProvider provider = missingContext.getProvider();
                String key = missingContext.getKey();
                ContextProviderMapper<?> contextProviderMapper = this.contextProviders.get(provider);
                if (contextProviderMapper == null) {
                    throw new CdkException("Unable to find a context provider for '" + provider + "'. Please consider updating the version of the plugin");
                }
                JsiiSerializable contextProps = UnsafeCast.unsafeCast((JsiiObject)((JsiiObject)missingContext.getProps()), (Class)contextProviderMapper.getContextType());
                try {
                    contextValue = contextProviderMapper.getContextValue((Object)contextProps);
                }
                catch (Exception e) {
                    throw new CdkException("An error occurred while resolving context value for the key '" + key + "' using '" + provider + "' provider: " + e.getMessage());
                }
                if (contextValue == null) {
                    throw new CdkException("Unable to resolve context value for the key '" + key + "' using '" + provider + "' provider");
                }
                contextIsEmpty = false;
                context.put(key, contextValue);
            }
            cloudManifest = this.synthesize(app, arguments, outputDirectory, environment, context);
        }
        if (!contextIsEmpty) {
            Path effectiveContextPath = outputDirectory.resolve(CDK_CONTEXT_FILE_NAME);
            String contextStrPretty = new GsonBuilder().setPrettyPrinting().create().toJson((Object)context);
            try {
                Files.write(effectiveContextPath, contextStrPretty.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                throw new CdkException("Unable to write effective context file to " + effectiveContextPath, (Throwable)e);
            }
        }
        logger.info("The cloud assembly has been successfully synthesized to {}", (Object)outputDirectory);
        return cloudManifest;
    }

    private Map<String, Object> readContext() {
        Map context;
        block8: {
            File contextFile = new File(this.project.getBasedir(), CDK_CONTEXT_FILE_NAME);
            if (contextFile.exists()) {
                try (FileReader reader = new FileReader(contextFile);){
                    context = (Map)new Gson().fromJson((Reader)reader, new TypeToken<Map<String, Object>>(){}.getType());
                    break block8;
                }
                catch (IOException e) {
                    throw new CdkException("Unable to read the runtime context from the " + contextFile);
                }
            }
            context = Maps.newHashMap();
        }
        return context;
    }

    private AssemblyManifest synthesize(String app, List<String> arguments, Path outputDirectory, Map<String, String> environment, Map<String, Object> context) {
        int exitCode;
        ImmutableMap appEnvironment = context.isEmpty() ? environment : ImmutableMap.builder().putAll(environment).put((Object)CONTEXT_VARIABLE_NAME, (Object)new Gson().toJson(context)).build();
        List<String> appExecutionCommand = this.buildAppExecutionCommand(app, arguments);
        ProcessContext processContext = ProcessContext.builder().withEnvironment(appEnvironment).build();
        try {
            exitCode = this.processRunner.run(appExecutionCommand, processContext);
        }
        catch (ProcessExecutionException e) {
            throw new CdkException("The synthesis has failed", (Throwable)e);
        }
        if (exitCode != 0 || !Files.exists(outputDirectory, new LinkOption[0])) {
            throw new CdkException("The synthesis has failed: the output directory doesn't exist");
        }
        return Manifest.loadAssemblyManifest((String)outputDirectory.resolve("manifest.json").toString());
    }

    private List<String> buildAppExecutionCommand(String app, List<String> arguments) {
        String java = Optional.ofNullable(this.toolchainManager.getToolchainFromBuildContext("jdk", this.session)).map(toolchain -> toolchain.findTool("java")).orElseGet(() -> System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        String classpath = Streams.concat((Stream[])new Stream[]{this.project.getArtifacts().stream().map(Artifact::getFile).map(File::toString), Stream.of(this.project.getBuild().getOutputDirectory()), this.project.getResources().stream().map(FileSet::getDirectory), Stream.of(Synthesizer.class.getProtectionDomain().getCodeSource().getLocation().getFile())}).collect(Collectors.joining(File.pathSeparator));
        return Stream.concat(Stream.of(java, "-cp", classpath, Synthesizer.class.getName(), app), arguments.stream()).collect(Collectors.toList());
    }

    private Optional<NodeVersion> getInstalledNodeVersion() {
        try {
            return Optional.of(this.processRunner.run((List)ImmutableList.of((Object)"node", (Object)"--version"))).flatMap(NodeVersion::parse);
        }
        catch (ProcessExecutionException e) {
            return Optional.empty();
        }
    }

    private NodeInstaller getNodeInstaller() {
        WindowsNodeInstaller nodeInstaller;
        String osName = System.getProperty("os.name").toLowerCase();
        Path localRepositoryDirectory = this.localRepositoryDirectory.toPath();
        if (osName.startsWith("Win".toLowerCase())) {
            nodeInstaller = new WindowsNodeInstaller(this.processRunner, localRepositoryDirectory);
        } else if (osName.startsWith("Mac".toLowerCase())) {
            nodeInstaller = new UnixNodeInstaller(this.processRunner, localRepositoryDirectory, "darwin");
        } else if (osName.startsWith("SunOS".toLowerCase())) {
            nodeInstaller = new UnixNodeInstaller(this.processRunner, localRepositoryDirectory, "sunos", "x64");
        } else if (osName.startsWith("Linux".toLowerCase())) {
            nodeInstaller = new UnixNodeInstaller(this.processRunner, localRepositoryDirectory, "linux");
        } else if (osName.startsWith("AIX".toLowerCase())) {
            nodeInstaller = new UnixNodeInstaller(this.processRunner, localRepositoryDirectory, "aix", "ppc64");
        } else {
            throw new NodeInstallationException("The platform is not supported: " + osName);
        }
        return nodeInstaller;
    }
}

