/*
 * Decompiled with CFR 0.152.
 */
package io.dataspray.aws.cdk;

import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCdkMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCdkMojo.class);
    @Parameter(defaultValue="${settings}", required=true, readonly=true)
    private Settings settings;
    @Parameter(property="aws.cdk.profile")
    private String profile;
    @Parameter(property="aws.cdk.cloud.assembly.directory", defaultValue="${project.build.directory}/cdk.out")
    private File cloudAssemblyDirectory;
    @Parameter(defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (!this.skip) {
            try {
                this.execute(this.cloudAssemblyDirectory.toPath(), Optional.ofNullable(Strings.emptyToNull((String)this.profile)), this.settings.isInteractiveMode());
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        } else {
            logger.debug("The execution is configured to be skipped");
        }
    }

    public abstract void execute(Path var1, Optional<String> var2, boolean var3);
}

