/*
 * Decompiled with CFR 0.152.
 */
package io.dataspray.aws.cdk.maven.node;

import io.dataspray.aws.cdk.maven.node.AbstractNodeInstaller;
import io.dataspray.aws.cdk.maven.node.NodeInstallationException;
import io.dataspray.aws.cdk.maven.node.NodeProcessRunner;
import io.dataspray.aws.cdk.maven.node.NodeVersion;
import io.dataspray.aws.cdk.maven.process.ProcessRunner;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsNodeInstaller
extends AbstractNodeInstaller {
    private static final Logger logger = LoggerFactory.getLogger(WindowsNodeInstaller.class);
    private final ProcessRunner processRunner;

    public WindowsNodeInstaller(ProcessRunner processRunner, Path localRepositoryPath) {
        super(localRepositoryPath, "win", System.getenv("ProgramFiles(x86)") != null ? "x64" : "x86");
        this.processRunner = processRunner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void download(NodeVersion version, String os, String arch, Path destination) {
        String filename = String.join((CharSequence)"-", "node", version.toString(), "win", arch) + ".zip";
        String downloadUrl = String.join((CharSequence)"/", "https://nodejs.org", "dist", version.toString(), filename);
        logger.info("Downloading Node.js {} from {}", (Object)version, (Object)downloadUrl);
        try (BufferedInputStream in = new BufferedInputStream(new URL(downloadUrl).openStream());
             ZipInputStream zipInputStream = new ZipInputStream(in);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                BufferedOutputStream outputStream;
                block37: {
                    Path entryPath = Paths.get(zipEntry.getName(), new String[0]);
                    if (entryPath.getNameCount() <= 1) continue;
                    Path path = destination.resolve(entryPath.subpath(1, entryPath.getNameCount()));
                    if (zipEntry.isDirectory()) {
                        Files.createDirectory(path, new FileAttribute[0]);
                        continue;
                    }
                    outputStream = new BufferedOutputStream(new FileOutputStream(path.toFile()));
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                        if (outputStream == null) continue;
                        if (throwable == null) break block37;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (outputStream == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    ((OutputStream)outputStream).close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            ((OutputStream)outputStream).close();
                            throw throwable3;
                        }
                    }
                    try {
                        ((OutputStream)outputStream).close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                ((OutputStream)outputStream).close();
            }
            return;
        }
        catch (IOException e) {
            throw new NodeInstallationException(e);
        }
    }

    @Override
    protected NodeProcessRunner toNodeProcessRunner(Path homeDirectory) {
        Path node = homeDirectory.resolve("node.exe");
        Path npmBinDirectory = homeDirectory.resolve("node_modules/npm/bin");
        Path npmCli = npmBinDirectory.resolve("npm-cli.js");
        Path npxCli = npmBinDirectory.resolve("npx-cli.js");
        return new NodeProcessRunner(this.processRunner, homeDirectory, node, npmCli, npxCli);
    }
}

