/*
 * Decompiled with CFR 0.152.
 */
package io.dataspray.aws.cdk.maven.node;

import io.dataspray.aws.cdk.maven.node.AbstractNodeInstaller;
import io.dataspray.aws.cdk.maven.node.NodeInstallationException;
import io.dataspray.aws.cdk.maven.node.NodeProcessRunner;
import io.dataspray.aws.cdk.maven.node.NodeVersion;
import io.dataspray.aws.cdk.maven.process.ProcessRunner;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixNodeInstaller
extends AbstractNodeInstaller {
    private static final Logger logger = LoggerFactory.getLogger(UnixNodeInstaller.class);
    private final ProcessRunner processRunner;

    public UnixNodeInstaller(ProcessRunner processRunner, Path localRepositoryDirectory, String os, String arch) {
        super(localRepositoryDirectory, os, arch);
        this.processRunner = processRunner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void download(NodeVersion version, String os, String arch, Path destination) {
        if (!Files.isDirectory(destination, new LinkOption[0])) {
            throw new IllegalArgumentException(destination + " is not a directory");
        }
        String filename = String.join((CharSequence)"-", "node", version.toString(), os, arch + ".tar.gz");
        String url = String.join((CharSequence)"/", "https://nodejs.org", "dist", version.toString(), filename);
        logger.info("Downloading Node.js {} from {}", (Object)version, (Object)url);
        try (BufferedInputStream in = new BufferedInputStream(new URL(url).openStream());
             TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)in));){
            TarArchiveEntry tarEntry;
            while ((tarEntry = tarArchiveInputStream.getNextTarEntry()) != null) {
                BufferedOutputStream outputStream;
                block39: {
                    Path tarEntryPath = Paths.get(tarEntry.getName(), new String[0]);
                    if (tarEntryPath.getNameCount() <= 1) continue;
                    Path path = destination.resolve(tarEntryPath.subpath(1, tarEntryPath.getNameCount()));
                    if (tarEntry.isSymbolicLink()) {
                        Files.createSymbolicLink(path, Paths.get(tarEntry.getLinkName(), new String[0]), new FileAttribute[0]);
                        continue;
                    }
                    Set<PosixFilePermission> filePermissions = this.getFilePermissions(tarEntry.getMode());
                    FileAttribute<Set<PosixFilePermission>> permissionFileAttribute = PosixFilePermissions.asFileAttribute(filePermissions);
                    if (tarEntry.isDirectory()) {
                        Files.createDirectories(path, permissionFileAttribute);
                        continue;
                    }
                    Files.createFile(path, permissionFileAttribute);
                    outputStream = new BufferedOutputStream(new FileOutputStream(path.toFile()));
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)tarArchiveInputStream, (OutputStream)outputStream);
                        if (outputStream == null) continue;
                        if (throwable == null) break block39;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (outputStream == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    ((OutputStream)outputStream).close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            ((OutputStream)outputStream).close();
                            throw throwable3;
                        }
                    }
                    try {
                        ((OutputStream)outputStream).close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                ((OutputStream)outputStream).close();
            }
            return;
        }
        catch (IOException e) {
            throw new NodeInstallationException(e);
        }
    }

    private Set<PosixFilePermission> getFilePermissions(int mode) {
        StringBuilder permissions = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int shift = (2 - i) * 3;
            permissions.append(this.getClassPermissions(mode >> shift & 7));
        }
        return PosixFilePermissions.fromString(permissions.toString());
    }

    private String getClassPermissions(int p) {
        if (p < 0 || p > 7) {
            throw new IllegalArgumentException("Invalid class permission: " + p);
        }
        return new String(new char[]{(p & 4) != 0 ? (char)'r' : '-', (p & 2) != 0 ? (char)'w' : '-', (p & 1) != 0 ? (char)'x' : '-'});
    }

    @Override
    protected NodeProcessRunner toNodeProcessRunner(Path homeDirectory) {
        Path path = homeDirectory.resolve("bin");
        Path node = path.resolve("node");
        Path npmBinDirectory = homeDirectory.resolve("lib/node_modules/npm/bin");
        Path npmCli = npmBinDirectory.resolve("npm-cli.js");
        Path npxCli = npmBinDirectory.resolve("npx-cli.js");
        return new NodeProcessRunner(this.processRunner, path, node, npmCli, npxCli);
    }
}

