/*
 * Decompiled with CFR 0.152.
 */
package io.dataspray.aws.cdk.maven;

import com.google.common.collect.Streams;
import com.google.common.hash.Hashing;
import io.dataspray.aws.cdk.AssetMetadata;
import io.dataspray.aws.cdk.ContainerAssetData;
import io.dataspray.aws.cdk.ContainerImageAssetMetadata;
import io.dataspray.aws.cdk.FileAssetData;
import io.dataspray.aws.cdk.FileAssetMetadata;
import io.dataspray.aws.cdk.maven.CdkPluginException;
import io.dataspray.aws.cdk.maven.DockerImageAssetPublisher;
import io.dataspray.aws.cdk.maven.FileAssetPublisher;
import io.dataspray.aws.cdk.maven.ImageBuild;
import io.dataspray.aws.cdk.maven.LoggingStackEventListener;
import io.dataspray.aws.cdk.maven.ParameterDefinition;
import io.dataspray.aws.cdk.maven.ParameterValue;
import io.dataspray.aws.cdk.maven.ResolvedEnvironment;
import io.dataspray.aws.cdk.maven.StackDefinition;
import io.dataspray.aws.cdk.maven.StackDeploymentException;
import io.dataspray.aws.cdk.maven.Stacks;
import io.dataspray.aws.cdk.maven.TemplateRef;
import io.dataspray.aws.cdk.maven.Toolkit;
import io.dataspray.aws.cdk.maven.ToolkitConfiguration;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.CloudFormationClientBuilder;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationException;
import software.amazon.awssdk.services.cloudformation.model.Output;
import software.amazon.awssdk.services.cloudformation.model.Stack;
import software.amazon.awssdk.services.cloudformation.model.StackStatus;

public class StackDeployer {
    private static final Logger logger = LoggerFactory.getLogger(StackDeployer.class);
    private static final String BOOTSTRAP_VERSION_OUTPUT = "BootstrapVersion";
    private static final String BUCKET_NAME_OUTPUT = "BucketName";
    private static final String BUCKET_DOMAIN_NAME_OUTPUT = "BucketDomainName";
    private static final String ASSET_PREFIX_SEPARATOR = "||";
    private static final String ZIP_PACKAGING = "zip";
    private static final String FILE_PACKAGING = "file";
    private static final String IMAGE_PACKAGING = "container-image";
    private static final int MAX_TEMPLATE_SIZE = 51200;
    private final CloudFormationClient client;
    private final Path cloudAssemblyDirectory;
    private final ResolvedEnvironment environment;
    private final ToolkitConfiguration toolkitConfiguration;
    private final FileAssetPublisher fileAssetPublisher;
    private final DockerImageAssetPublisher dockerImagePublisher;
    private final Settings settings;

    public StackDeployer(Path cloudAssemblyDirectory, ResolvedEnvironment environment, ToolkitConfiguration toolkitConfiguration, FileAssetPublisher fileAssetPublisher, DockerImageAssetPublisher dockerImagePublisher, Settings settings) {
        this.cloudAssemblyDirectory = cloudAssemblyDirectory;
        this.environment = environment;
        this.toolkitConfiguration = toolkitConfiguration;
        this.fileAssetPublisher = fileAssetPublisher;
        this.dockerImagePublisher = dockerImagePublisher;
        this.settings = settings;
        this.client = (CloudFormationClient)((CloudFormationClientBuilder)((CloudFormationClientBuilder)CloudFormationClient.builder().region(environment.getRegion())).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)environment.getCredentials()))).build();
    }

    public Stack deploy(StackDefinition stackDefinition, Map<String, String> parameters, Map<String, String> tags) {
        Stack stack;
        String stackName = stackDefinition.getStackName();
        logger.info("Deploying '{}' stack", (Object)stackName);
        HashMap<String, ParameterValue> stackParameters = new HashMap<String, ParameterValue>();
        Stack deployedStack = Stacks.findStack(this.client, stackName).orElse(null);
        if (deployedStack != null) {
            if (Stacks.isInProgress(deployedStack)) {
                logger.info("Waiting until stack '{}' reaches stable state", (Object)deployedStack.stackName());
                deployedStack = this.awaitCompletion(deployedStack);
            }
            if (deployedStack.stackStatus() == StackStatus.ROLLBACK_COMPLETE || deployedStack.stackStatus() == StackStatus.ROLLBACK_FAILED) {
                logger.warn("The stack '{}' is in {} state after unsuccessful creation. The stack will be deleted and re-created.", (Object)stackName, (Object)deployedStack.stackStatus());
                deployedStack = Stacks.awaitCompletion(this.client, Stacks.deleteStack(this.client, deployedStack.stackName()));
            }
            if (Stacks.isFailed(deployedStack)) {
                throw StackDeploymentException.builder(stackName, this.environment).withCause("The stack '" + stackName + "' is in the failed state " + deployedStack.stackStatus()).build();
            }
            if (deployedStack.stackStatus() != StackStatus.DELETE_COMPLETE) {
                deployedStack.parameters().forEach(p -> stackParameters.put(p.parameterKey(), ParameterValue.unchanged()));
            }
        }
        Streams.concat((Stream[])new Stream[]{stackDefinition.getParameterValues().entrySet().stream(), parameters.entrySet().stream()}).filter(parameter -> parameter.getKey() != null && parameter.getValue() != null).forEach(parameter -> stackParameters.put((String)parameter.getKey(), ParameterValue.value((String)parameter.getValue())));
        Toolkit toolkit = null;
        ArrayList<Runnable> publishmentTasks = new ArrayList<Runnable>();
        block14: for (AssetMetadata asset : stackDefinition.getAssets()) {
            switch (asset.getPackaging()) {
                case "file": 
                case "zip": {
                    if (toolkit == null) {
                        toolkit = this.getToolkit(stackDefinition);
                    }
                    FileAssetMetadata fileAsset = (FileAssetMetadata)asset;
                    String bucketName = toolkit.getBucketName();
                    String prefix = this.generatePrefix(fileAsset);
                    String filename = this.generateFilename(fileAsset);
                    FileAssetData fileData = fileAsset.getData();
                    stackParameters.put(fileData.getS3BucketParameter(), ParameterValue.value(toolkit.getBucketName()));
                    stackParameters.put(fileData.getS3KeyParameter(), ParameterValue.value(String.join((CharSequence)ASSET_PREFIX_SEPARATOR, prefix, filename)));
                    stackParameters.put(fileData.getArtifactHashParameter(), ParameterValue.value(fileAsset.getSourceHash()));
                    publishmentTasks.add(() -> {
                        Path file = this.cloudAssemblyDirectory.resolve(fileAsset.getPath());
                        try {
                            this.fileAssetPublisher.publish(file, prefix + filename, bucketName);
                        }
                        catch (IOException e) {
                            throw StackDeploymentException.builder(stackName, this.environment).withCause("An error occurred while publishing the file asset " + file).withCause(e).build();
                        }
                    });
                    continue block14;
                }
                case "container-image": {
                    ContainerImageAssetMetadata imageAsset = (ContainerImageAssetMetadata)asset;
                    publishmentTasks.add(this.createImagePublishmentTask(stackName, imageAsset));
                    continue block14;
                }
            }
            throw StackDeploymentException.builder(stackName, this.environment).withCause("The asset packaging " + asset.getPackaging() + " is not supported. You might need to update the plugin in order to support the assets of this type").build();
        }
        Map<String, ParameterValue> effectiveParameters = stackParameters.entrySet().stream().filter(parameter -> stackDefinition.getParameters().containsKey(parameter.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        TemplateRef templateRef = this.getTemplateRef(stackDefinition, publishmentTasks);
        List missingParameters = stackDefinition.getParameters().values().stream().filter(parameterDefinition -> parameterDefinition.getDefaultValue() == null).filter(parameterDefinition -> !effectiveParameters.containsKey(parameterDefinition.getName())).map(ParameterDefinition::getName).collect(Collectors.toList());
        if (!missingParameters.isEmpty()) {
            throw StackDeploymentException.builder(stackName, this.environment).withCause("The values for the following template parameters are missing: " + String.join((CharSequence)", ", missingParameters)).build();
        }
        try {
            publishmentTasks.forEach(Runnable::run);
        }
        catch (CdkPluginException e) {
            throw StackDeploymentException.builder(stackName, this.environment).withCause(e.getMessage()).withCause(e.getCause()).build();
        }
        catch (Exception e) {
            throw StackDeploymentException.builder(stackName, this.environment).withCause(e).build();
        }
        boolean updated = true;
        if (deployedStack != null && deployedStack.stackStatus() != StackStatus.DELETE_COMPLETE) {
            try {
                stack = Stacks.updateStack(this.client, stackName, templateRef, effectiveParameters, tags);
            }
            catch (CloudFormationException e) {
                AwsErrorDetails errorDetails = e.awsErrorDetails();
                if (!errorDetails.errorCode().equals("ValidationError") || !errorDetails.errorMessage().startsWith("No updates are to be performed")) {
                    throw e;
                }
                logger.info("No changes of the '{}' stack are detected. The deployment will be skipped", (Object)stackName);
                stack = deployedStack;
                updated = false;
            }
        } else {
            stack = Stacks.createStack(this.client, stackName, templateRef, effectiveParameters, tags);
        }
        if (updated) {
            if (!Stacks.isCompleted(stack)) {
                logger.info("Waiting until '{}' reaches stable state", (Object)stackName);
                stack = this.awaitCompletion(stack);
            }
            if (Stacks.isFailed(stack)) {
                throw StackDeploymentException.builder(stackName, this.environment).withCause("The deployment has failed: " + stack.stackStatus()).build();
            }
            if (Stacks.isRolledBack(stack)) {
                throw StackDeploymentException.builder(stackName, this.environment).withCause("The deployment has been unsuccessful, the stack has been rolled back to its previous state").build();
            }
            logger.info("The stack '{}' has been successfully deployed", (Object)stackName);
        }
        return stack;
    }

    private Runnable createImagePublishmentTask(String stackName, ContainerImageAssetMetadata imageAsset) {
        Path dockerfilePath;
        Path contextDirectory = this.cloudAssemblyDirectory.resolve(imageAsset.getPath());
        if (!Files.exists(contextDirectory, new LinkOption[0])) {
            throw StackDeploymentException.builder(stackName, this.environment).withCause("The Docker context directory doesn't exist: " + contextDirectory).build();
        }
        ContainerAssetData imageData = imageAsset.getData();
        if (imageData.getFile() != null) {
            dockerfilePath = contextDirectory.resolve(imageData.getFile());
            if (!Files.exists(dockerfilePath, new LinkOption[0])) {
                throw StackDeploymentException.builder(stackName, this.environment).withCause("The Dockerfile doesn't exist: " + dockerfilePath).build();
            }
        } else {
            dockerfilePath = this.findDockerfile(contextDirectory).orElseThrow(() -> StackDeploymentException.builder(stackName, this.environment).withCause("Unable to find Dockerfile in the context directory " + contextDirectory).build());
        }
        return () -> {
            String localTag = String.join((CharSequence)"-", "cdkasset", imageAsset.getId().toLowerCase());
            ImageBuild imageBuild = ImageBuild.builder().withContextDirectory(contextDirectory).withDockerfile(dockerfilePath).withImageTag(localTag).withArguments(imageData.getBuildArguments()).withTarget(imageData.getTarget()).build();
            this.dockerImagePublisher.publish(imageData.getRepositoryName(), imageData.getImageTag(), imageBuild);
        };
    }

    private Optional<Path> findDockerfile(Path contextDirectory) {
        Path dockerfile = contextDirectory.resolve("Dockerfile");
        if (!Files.exists(dockerfile, new LinkOption[0])) {
            dockerfile = contextDirectory.resolve("dockerfile");
        }
        return Optional.of(dockerfile).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }

    private TemplateRef getTemplateRef(StackDefinition stackDefinition, List<Runnable> deploymentTasks) {
        TemplateRef templateRef;
        Path templateFile = this.cloudAssemblyDirectory.resolve(stackDefinition.getTemplateFile());
        try {
            templateRef = this.readTemplateBody(templateFile, 51200L).map(TemplateRef::fromString).orElse(null);
        }
        catch (IOException e) {
            throw StackDeploymentException.builder(stackDefinition.getStackName(), this.environment).withCause("Unable to read the template file: " + templateFile).withCause(e).build();
        }
        if (templateRef == null) {
            String contentHash;
            Toolkit toolkit = this.getToolkit(stackDefinition);
            try {
                contentHash = this.hash(templateFile.toFile());
            }
            catch (IOException e) {
                throw StackDeploymentException.builder(stackDefinition.getStackName(), this.environment).withCause("Unable to read the template file: " + templateFile).withCause(e).build();
            }
            String objectName = "cdk/" + stackDefinition.getStackName() + "/" + contentHash + ".json";
            deploymentTasks.add(() -> {
                try {
                    this.fileAssetPublisher.publish(templateFile, objectName, toolkit.getBucketName());
                }
                catch (IOException e) {
                    throw StackDeploymentException.builder(stackDefinition.getStackName(), this.environment).withCause("An error occurred while uploading the template file to the deployment bucket").withCause(e).build();
                }
            });
            templateRef = TemplateRef.fromUrl("https://" + toolkit.getBucketDomainName() + "/" + objectName);
        }
        return templateRef;
    }

    public Optional<Stack> destroy(StackDefinition stackDefinition) {
        Stack stack = Stacks.findStack(this.client, stackDefinition.getStackName()).orElse(null);
        if (stack != null && stack.stackStatus() != StackStatus.DELETE_COMPLETE) {
            logger.info("The stack '${} is being deleted, awaiting until the operation is completed", (Object)stackDefinition.getStackName());
            stack = this.awaitCompletion(Stacks.deleteStack(this.client, stack.stackId()));
            if (stack.stackStatus() != StackStatus.DELETE_COMPLETE) {
                throw new CdkPluginException("The deletion of '" + stackDefinition.getStackName() + "' stack has failed: " + stack.stackStatus());
            }
            logger.info("The stack '{}' has been successfully deleted", (Object)stack.stackName());
        } else {
            logger.warn("The generated template for the stack '{}' doesn't have any resources defined. The deployment will be skipped", (Object)stackDefinition.getStackName());
        }
        return Optional.ofNullable(stack);
    }

    private String hash(File file) throws IOException {
        return com.google.common.io.Files.asByteSource((File)file).hash(Hashing.sha256()).toString();
    }

    private String generateFilename(FileAssetMetadata fileAsset) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(fileAsset.getSourceHash());
        if (fileAsset.getPackaging().equals(ZIP_PACKAGING)) {
            fileName.append('.').append(ZIP_PACKAGING);
        } else {
            int extensionDelimiter = fileAsset.getPath().lastIndexOf(46);
            if (extensionDelimiter > 0) {
                fileName.append(fileAsset.getPath().substring(extensionDelimiter));
            }
        }
        return fileName.toString();
    }

    private String generatePrefix(FileAssetMetadata fileAsset) {
        StringBuilder prefix = new StringBuilder();
        prefix.append("assets").append('/');
        if (!fileAsset.getId().equals(fileAsset.getSourceHash())) {
            prefix.append(fileAsset.getId()).append('/');
        }
        return prefix.toString();
    }

    private Optional<String> readTemplateBody(Path template, long limit) throws IOException {
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream templateBody = new ByteArrayOutputStream();
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(template.toFile()));){
            int bytesRead;
            while ((long)templateBody.size() <= limit && (bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                templateBody.write(buffer, 0, bytesRead);
            }
        }
        if ((long)templateBody.size() > limit) {
            return Optional.empty();
        }
        return Optional.of(templateBody.toString(StandardCharsets.UTF_8.name()));
    }

    private Toolkit getToolkit(StackDefinition stack) {
        Integer toolkitStackVersion;
        Stack toolkitStack = Stacks.findStack(this.client, this.toolkitConfiguration.getStackName()).orElse(null);
        if (toolkitStack != null && Stacks.isInProgress(toolkitStack)) {
            logger.info("Waiting until toolkit stack reaches stable state, environment={}, stackName={}", (Object)this.environment, (Object)this.toolkitConfiguration.getStackName());
            toolkitStack = this.awaitCompletion(toolkitStack);
        }
        if (toolkitStack == null || toolkitStack.stackStatus() == StackStatus.DELETE_COMPLETE || toolkitStack.stackStatus() == StackStatus.ROLLBACK_COMPLETE) {
            throw StackDeploymentException.builder(stack.getStackName(), this.environment).withCause("The stack " + stack.getStackName() + " requires a bootstrap. Did you forged to add 'bootstrap' goal to the execution").build();
        }
        if (Stacks.isFailed(toolkitStack)) {
            throw StackDeploymentException.builder(stack.getStackName(), this.environment).withCause("The toolkit stack is in failed state. Please make sure that the toolkit stack is stable before the deployment").build();
        }
        Map<String, String> outputs = toolkitStack.outputs().stream().collect(Collectors.toMap(Output::outputKey, Output::outputValue));
        if (stack.getRequiredToolkitStackVersion() != null && (toolkitStackVersion = Optional.ofNullable(outputs.get(BOOTSTRAP_VERSION_OUTPUT)).map(Integer::parseInt).orElse(0)) < stack.getRequiredToolkitStackVersion()) {
            throw StackDeploymentException.builder(stack.getStackName(), this.environment).withCause("The toolkit stack version is lower than the minimum version required by the stack. Please update the toolkit stack or add 'bootstrap' goal to the plugin execution if you want the plugin to automatically create or update toolkit stack").build();
        }
        String bucketName = outputs.get(BUCKET_NAME_OUTPUT);
        if (bucketName == null) {
            throw StackDeploymentException.builder(stack.getStackName(), this.environment).withCause("The toolkit stack " + this.toolkitConfiguration.getStackName() + " doesn't have a required output '" + BUCKET_NAME_OUTPUT + "'").build();
        }
        String bucketDomainName = outputs.get(BUCKET_DOMAIN_NAME_OUTPUT);
        if (bucketDomainName == null) {
            throw StackDeploymentException.builder(stack.getStackName(), this.environment).withCause("The toolkit stack " + this.toolkitConfiguration.getStackName() + " doesn't have a required output '" + BUCKET_DOMAIN_NAME_OUTPUT + "'").build();
        }
        return new Toolkit(bucketName, bucketDomainName);
    }

    private Stack awaitCompletion(Stack stack) {
        Stack completedStack = logger.isInfoEnabled() && this.settings.isInteractiveMode() ? Stacks.awaitCompletion(this.client, stack, new LoggingStackEventListener()) : Stacks.awaitCompletion(this.client, stack);
        return completedStack;
    }
}

