/*
 * Decompiled with CFR 0.152.
 */
package io.dataspray.aws.cdk.maven;

import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class ImageBuild {
    @Nonnull
    private final Path contextDirectory;
    @Nonnull
    private final Path dockerfile;
    @Nonnull
    private final String imageTag;
    @Nullable
    private final String target;
    @Nonnull
    Map<String, String> arguments;

    private ImageBuild(@NotNull Path contextDirectory, @NotNull Path dockerfile, @NotNull String imageTag, @Nullable String target, @Nullable Map<String, String> arguments) {
        this.contextDirectory = Objects.requireNonNull(contextDirectory, "Docker context directory path can't be null");
        this.dockerfile = Objects.requireNonNull(dockerfile, "Docker Dockerfile path can't be null");
        this.imageTag = Objects.requireNonNull(imageTag, "Image tag can't be null");
        this.target = target;
        this.arguments = arguments != null ? ImmutableMap.copyOf(arguments) : ImmutableMap.of();
    }

    @Nonnull
    public Path getContextDirectory() {
        return this.contextDirectory;
    }

    @Nonnull
    public Path getDockerfile() {
        return this.dockerfile;
    }

    @Nonnull
    public String getImageTag() {
        return this.imageTag;
    }

    @Nullable
    public String getTarget() {
        return this.target;
    }

    @Nonnull
    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return "ImageBuild{contextDirectory=" + this.contextDirectory + ", dockerfile=" + this.dockerfile + ", imageTag='" + this.imageTag + '\'' + ", target='" + this.target + '\'' + ", arguments=" + this.arguments + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        Map<String, String> arguments;
        private Path contextDirectory;
        private Path dockerfile;
        private String imageTag;
        private String target;

        private Builder() {
        }

        public Builder withContextDirectory(@Nonnull Path contextDirectory) {
            this.contextDirectory = contextDirectory;
            return this;
        }

        public Builder withDockerfile(@Nonnull Path dockerfile) {
            this.dockerfile = dockerfile;
            return this;
        }

        public Builder withImageTag(@Nonnull String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        public Builder withTarget(@Nullable String target) {
            this.target = target;
            return this;
        }

        public Builder withArguments(@Nullable Map<String, String> arguments) {
            this.arguments = arguments;
            return this;
        }

        public ImageBuild build() {
            return new ImageBuild(this.contextDirectory, this.dockerfile, this.imageTag, this.target, this.arguments);
        }
    }
}

