/*
 * Decompiled with CFR 0.152.
 */
package io.dataspray.aws.cdk.maven;

import io.dataspray.aws.cdk.maven.ResolvedEnvironment;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

public class FileAssetPublisher {
    private static final Logger logger = LoggerFactory.getLogger(FileAssetPublisher.class);
    private final ResolvedEnvironment environment;
    private S3AsyncClient s3Client;

    public FileAssetPublisher(ResolvedEnvironment environment) {
        this.environment = environment;
    }

    public void publish(Path file, String objectName, String bucketName) throws IOException {
        logger.info("Publishing file asset, file={}, bucketName={}, objectName={}", new Object[]{file, bucketName, objectName});
        if (Files.isDirectory(file, new LinkOption[0])) {
            this.publishDirectory(file, objectName, bucketName);
        } else {
            this.publishFile(file, objectName, bucketName);
        }
    }

    private void publishDirectory(final Path directory, String objectName, String bucketName) throws IOException {
        try (S3ObjectOutputStream outputStream = new S3ObjectOutputStream(this.getS3Client(), bucketName, objectName, "application/zip");
             final ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    ZipEntry zipEntry = new ZipEntry(directory.relativize(file).toString());
                    zipOutputStream.putNextEntry(zipEntry);
                    Files.copy(file, zipOutputStream);
                    zipOutputStream.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private void publishFile(Path file, String objectName, String bucketName) throws IOException {
        try (S3ObjectOutputStream outputStream = new S3ObjectOutputStream(this.getS3Client(), bucketName, objectName);){
            Files.copy(file, outputStream);
        }
    }

    private S3AsyncClient getS3Client() {
        if (this.s3Client == null) {
            this.s3Client = (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().region(this.environment.getRegion())).credentialsProvider(this.environment.getCredentialsProvider())).build();
        }
        return this.s3Client;
    }

    private static class S3ObjectOutputStream
    extends OutputStream {
        private static final int MINIMUM_PART_SIZE = 0x500000;
        private S3AsyncClient s3Client;
        private CreateMultipartUploadResponse createUploadResponse;
        private List<CompletableFuture<CompletedPart>> parts;
        private ByteBuffer buffer;

        S3ObjectOutputStream(S3AsyncClient s3Client, String bucketName, String objectKey) {
            this(s3Client, bucketName, objectKey, null);
        }

        S3ObjectOutputStream(S3AsyncClient s3Client, String bucketName, String objectKey, @Nullable String contentType) {
            this(s3Client, bucketName, objectKey, contentType, 0x500000);
        }

        S3ObjectOutputStream(S3AsyncClient s3Client, String bucketName, String objectKey, String contentType, int partSize) {
            if (partSize <= 0) {
                throw new IllegalArgumentException("The minimum part size is 5 MB (5242880 bytes)");
            }
            this.s3Client = s3Client;
            this.buffer = ByteBuffer.allocate(partSize);
            this.parts = new ArrayList<CompletableFuture<CompletedPart>>();
            CreateMultipartUploadRequest uploadRequest = this.buildUploadRequest(bucketName, objectKey, contentType);
            this.createUploadResponse = (CreateMultipartUploadResponse)s3Client.createMultipartUpload(uploadRequest).join();
        }

        @Override
        public void write(int b) throws IOException {
            if (this.isClosed()) {
                throw new IOException("The stream is closed");
            }
            if (!this.buffer.hasRemaining()) {
                this.flush();
            }
            this.buffer.put((byte)b);
        }

        @Override
        public void write(@NotNull byte[] bytes, int offset, int length) throws IOException {
            if (this.isClosed()) {
                throw new IOException("The stream is closed");
            }
            int remaining = this.buffer.remaining();
            this.buffer.put(bytes, offset, Math.min(remaining, length));
            if (remaining < length) {
                this.flush();
                this.write(bytes, offset + remaining, length - remaining);
            }
        }

        @Override
        public void flush() {
            if (!this.isClosed()) {
                this.buffer.flip();
                if (this.buffer.remaining() > 0) {
                    CompletionStage part = ((CompletableFuture)CompletableFuture.completedFuture(this.parts.size() + 1).thenApply(this::buildUploadPartRequest)).thenCompose(uploadPartRequest -> {
                        AsyncRequestBody requestBody = AsyncRequestBody.fromByteBuffer((ByteBuffer)this.buffer);
                        return this.s3Client.uploadPart(uploadPartRequest, requestBody).thenApply(r -> this.completedPart(r.eTag(), uploadPartRequest.partNumber()));
                    });
                    this.parts.add((CompletableFuture<CompletedPart>)part);
                }
                this.buffer.clear();
            }
        }

        @Override
        public void close() {
            if (!this.isClosed()) {
                this.flush();
                ((CompletableFuture)this.join(this.parts).thenCompose(completedParts -> {
                    CompleteMultipartUploadRequest completeUploadRequest = this.buildCompleteUploadRequest((Collection<CompletedPart>)completedParts);
                    return this.s3Client.completeMultipartUpload(completeUploadRequest);
                })).join();
                this.s3Client = null;
                this.createUploadResponse = null;
                this.buffer = null;
                this.parts = null;
            }
        }

        private <T> CompletableFuture<List<T>> join(List<CompletableFuture<T>> futures) {
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(r -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
        }

        private boolean isClosed() {
            return this.buffer == null;
        }

        private CreateMultipartUploadRequest buildUploadRequest(String bucketName, String objectKey, @Nullable String contentType) {
            CreateMultipartUploadRequest.Builder requestBuilder = CreateMultipartUploadRequest.builder().bucket(bucketName).key(objectKey);
            if (contentType != null) {
                requestBuilder = requestBuilder.contentType(contentType);
            }
            return (CreateMultipartUploadRequest)requestBuilder.build();
        }

        private UploadPartRequest buildUploadPartRequest(int partNumber) {
            return (UploadPartRequest)UploadPartRequest.builder().bucket(this.createUploadResponse.bucket()).key(this.createUploadResponse.key()).uploadId(this.createUploadResponse.uploadId()).partNumber(Integer.valueOf(partNumber)).build();
        }

        private CompletedPart completedPart(String eTag, int partNumber) {
            return (CompletedPart)CompletedPart.builder().eTag(eTag).partNumber(Integer.valueOf(partNumber)).build();
        }

        private CompleteMultipartUploadRequest buildCompleteUploadRequest(Collection<CompletedPart> parts) {
            CompletedMultipartUpload completedMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(parts).build();
            return (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(this.createUploadResponse.bucket()).key(this.createUploadResponse.key()).uploadId(this.createUploadResponse.uploadId()).multipartUpload(completedMultipartUpload).build();
        }
    }
}

