/*
 * Decompiled with CFR 0.152.
 */
package io.dataspray.aws.cdk.maven.text.table;

import com.google.common.collect.ImmutableList;
import io.dataspray.aws.cdk.maven.text.Ansi;
import io.dataspray.aws.cdk.maven.text.table.Alignment;
import io.dataspray.aws.cdk.maven.text.table.Cell;
import java.util.List;
import javax.annotation.Nullable;

public class Column
extends Cell {
    private static final List<Ansi.Parameter> DEFAULT_COLUMN_FORMAT = ImmutableList.of((Object)Ansi.Decoration.BOLD);
    private final int width;

    protected Column(String heading, int width, @Nullable Alignment alignment, List<Ansi.Parameter> format) {
        super(heading, alignment != null ? alignment : Alignment.LEFT, !format.isEmpty() ? format : DEFAULT_COLUMN_FORMAT);
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public String getHeading() {
        return this.getValue();
    }

    public static Column of(String heading, int width, Alignment alignment, Ansi.Parameter ... parameters) {
        return new Column(heading, width, alignment, (List<Ansi.Parameter>)ImmutableList.copyOf((Object[])parameters));
    }

    public static Column of(String heading, int width, Ansi.Parameter ... parameters) {
        return new Column(heading, width, null, (List<Ansi.Parameter>)ImmutableList.copyOf((Object[])parameters));
    }

    @Override
    public String toString() {
        return "Column{heading='" + this.getHeading() + '\'' + ", width='" + this.getWidth() + '\'' + ", alignment=" + this.getAlignment() + ", ansiParameters=" + this.getAnsiParameters() + '}';
    }
}

