/*
 * Decompiled with CFR 0.152.
 */
package io.dataspray.aws.cdk.maven.process;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProcessContext {
    public static final ProcessContext DEFAULT = ProcessContext.builder().build();
    private final File workingDirectory;
    private final Map<String, String> environment;
    private final OutputStream output;

    private ProcessContext(@Nullable File workingDirectory, @Nullable Map<String, String> environment, @Nullable OutputStream output) {
        this.workingDirectory = workingDirectory;
        this.environment = environment;
        this.output = output;
    }

    public Optional<File> getWorkingDirectory() {
        return Optional.ofNullable(this.workingDirectory);
    }

    public Optional<Map<String, String>> getEnvironment() {
        return Optional.ofNullable(this.environment);
    }

    public Optional<OutputStream> getOutput() {
        return Optional.ofNullable(this.output);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private File workingDirectory;
        private Map<String, String> environment;
        private OutputStream output = System.out;

        private Builder() {
        }

        public Builder withEnvironment(@Nonnull Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
            return this;
        }

        public Builder withWorkingDirectory(@Nonnull File workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder withOutput(@Nonnull OutputStream output) {
            this.output = output;
            return this;
        }

        public ProcessContext build() {
            return new ProcessContext(this.workingDirectory, this.environment, this.output);
        }
    }
}

