/*
 * Decompiled with CFR 0.152.
 */
package io.dataspray.aws.cdk.maven.node;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class NodeVersion
implements Comparable<NodeVersion> {
    private static final Comparator<NodeVersion> COMPARATOR = Comparator.comparing(NodeVersion::getMajorVersion).thenComparing(NodeVersion::getMinorVersion).thenComparing(NodeVersion::getRevisionVersion);
    private final int[] versions;

    private NodeVersion(int[] versions) {
        this.versions = versions;
    }

    public int getMajorVersion() {
        return this.versions[0];
    }

    public int getMinorVersion() {
        return this.versions[1];
    }

    public int getRevisionVersion() {
        return this.versions[2];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeVersion that = (NodeVersion)o;
        return Arrays.equals(this.versions, that.versions);
    }

    public int hashCode() {
        return Arrays.hashCode(this.versions);
    }

    public String toString() {
        return Arrays.stream(this.versions).mapToObj(String::valueOf).collect(Collectors.joining(".", "v", ""));
    }

    public static Optional<NodeVersion> parse(String version) {
        if (!(version = version.trim()).startsWith("v")) {
            return Optional.empty();
        }
        try {
            int[] versions = Arrays.stream(version.substring(1).split("\\.")).mapToInt(Integer::parseInt).toArray();
            return versions.length == 3 ? Optional.of(new NodeVersion(versions)) : Optional.empty();
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static NodeVersion of(int major, int minor, int revision) {
        return new NodeVersion(new int[]{major, minor, revision});
    }

    @Override
    public int compareTo(@NotNull NodeVersion nodeVersion) {
        return COMPARATOR.compare(this, nodeVersion);
    }
}

