/*
 * Decompiled with CFR 0.152.
 */
package io.dataspray.aws.cdk.maven.node;

import io.dataspray.aws.cdk.maven.node.NodeClient;
import io.dataspray.aws.cdk.maven.node.NodeInstallationException;
import io.dataspray.aws.cdk.maven.node.NodeInstaller;
import io.dataspray.aws.cdk.maven.node.NodeProcessRunner;
import io.dataspray.aws.cdk.maven.node.NodeVersion;
import io.dataspray.aws.cdk.maven.node.UnixNodeInstaller;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeInstaller
implements NodeInstaller {
    private static final Logger logger = LoggerFactory.getLogger(UnixNodeInstaller.class);
    private static final byte[] INSTALLED_STATE = new byte[]{1};
    private final String os;
    private final String arch;
    private final Path localRepositoryDirectory;

    protected AbstractNodeInstaller(Path localRepositoryDirectory, String os, String arch) {
        this.os = os;
        this.arch = arch;
        this.localRepositoryDirectory = localRepositoryDirectory;
    }

    @Override
    public NodeClient install(NodeVersion version) {
        String artifactName = String.join((CharSequence)"-", "node", this.os, this.arch);
        Path homeDirectory = this.localRepositoryDirectory.resolve(Paths.get("io", "dataspray", artifactName, version.toString()));
        Path stateFile = homeDirectory.resolve(".state");
        if (!this.isInstallationCompleted(stateFile)) {
            try {
                Files.createDirectories(homeDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new NodeInstallationException("Failed to create directory structure for Node.js in the local Maven repository");
            }
            try (FileChannel fileChannel = FileChannel.open(stateFile, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                fileChannel.lock();
                ByteBuffer buffer = ByteBuffer.allocate(1);
                if (fileChannel.read(buffer) == -1) {
                    logger.info("Node.js {} wasn't found in the local Maven repository. It will be downloaded from {}", (Object)version, (Object)"https://nodejs.org");
                    Files.walk(homeDirectory, new FileVisitOption[0]).filter(file -> !file.equals(stateFile) && !file.equals(homeDirectory)).forEach(file -> {
                        try {
                            Files.deleteIfExists(file);
                        }
                        catch (IOException e) {
                            throw new NodeInstallationException(e);
                        }
                    });
                    this.download(version, this.os, this.arch, homeDirectory);
                    buffer.put(INSTALLED_STATE);
                    buffer.flip();
                    fileChannel.write(buffer);
                    logger.info("The Node.js {} has been successfully installed to {}", (Object)version, (Object)homeDirectory);
                }
            }
            catch (IOException e) {
                throw new NodeInstallationException(e);
            }
        }
        return this.toNodeProcessRunner(homeDirectory);
    }

    private boolean isInstallationCompleted(Path state) {
        try {
            return Files.exists(state, new LinkOption[0]) && Files.readAllBytes(state).length > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected abstract void download(NodeVersion var1, String var2, String var3, Path var4);

    protected abstract NodeProcessRunner toNodeProcessRunner(Path var1);
}

