/*
 * Decompiled with CFR 0.152.
 */
package io.dataspray.aws.cdk.maven.context;

import io.dataspray.aws.cdk.maven.CdkPluginException;
import io.dataspray.aws.cdk.maven.context.AwsClientProvider;
import io.dataspray.aws.cdk.maven.context.ContextProvider;
import io.dataspray.aws.cdk.maven.context.ContextProviders;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.ssm.model.Parameter;
import software.amazon.awssdk.services.ssm.model.ParameterNotFoundException;

public class SsmContextProvider
implements ContextProvider {
    public static final String KEY = "ssm";
    private final AwsClientProvider awsClientProvider;

    public SsmContextProvider(AwsClientProvider awsClientProvider) {
        this.awsClientProvider = awsClientProvider;
    }

    @Override
    public JsonValue getContextValue(JsonObject properties) {
        String environment = ContextProviders.buildEnvironment(properties);
        String parameterName = ContextProviders.getRequiredProperty(properties, "parameterName");
        try (SsmClient ssmClient = this.awsClientProvider.getClient(SsmClient.class, environment);){
            String value;
            try {
                GetParameterResponse response = ssmClient.getParameter(this.parameterRequest(parameterName));
                value = Optional.of(response).map(GetParameterResponse::parameter).map(Parameter::value).orElse(null);
            }
            catch (ParameterNotFoundException e) {
                value = null;
            }
            if (value == null) {
                throw new CdkPluginException("The SSM parameter '" + parameterName + "' is not available for the following environment: " + environment);
            }
            JsonString jsonString = Json.createValue(value);
            return jsonString;
        }
    }

    private GetParameterRequest parameterRequest(String parameterName) {
        return (GetParameterRequest)GetParameterRequest.builder().name(parameterName).build();
    }
}

