/*
 * Decompiled with CFR 0.152.
 */
package io.dataspray.aws.cdk.maven.context;

import com.google.common.collect.ImmutableMap;
import io.dataspray.aws.cdk.maven.context.AwsClientProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.SdkClient;

public class AwsClientProviderBuilder {
    private final Map<Class<? extends SdkClient>, Function<String, ? extends SdkClient>> factories = new HashMap<Class<? extends SdkClient>, Function<String, ? extends SdkClient>>();

    public <B extends AwsClientBuilder<B, C>, C extends SdkClient> AwsClientProviderBuilder withClientFactory(Class<C> clientType, Function<String, C> factory) {
        this.factories.put(clientType, factory);
        return this;
    }

    public AwsClientProvider build() {
        ImmutableMap clientFactories = ImmutableMap.copyOf(this.factories);
        return new AwsClientProvider((Map)clientFactories){
            final /* synthetic */ Map val$clientFactories;
            {
                this.val$clientFactories = map;
            }

            @Override
            public <T extends SdkClient> T getClient(Class<T> clientType, String environment) {
                Function clientFactory = (Function)this.val$clientFactories.get(clientType);
                if (clientFactory == null) {
                    throw new IllegalArgumentException("There's no factory registered for " + clientType.getSimpleName() + " client");
                }
                return (T)((SdkClient)clientType.cast(clientFactory.apply(environment)));
            }
        };
    }
}

