/*
 * Decompiled with CFR 0.152.
 */
package io.dataspray.aws.cdk;

import io.dataspray.aws.cdk.Stacks;
import java.util.ArrayList;
import java.util.Iterator;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.Output;
import software.amazon.awssdk.services.cloudformation.model.Stack;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.ObjectVersion;

public class ToolkitStacks {
    private ToolkitStacks() {
    }

    public static Stack deleteToolkitStack(CloudFormationClient client, Stack stack) {
        Stacks.findOutput((Stack)stack, (String)"BucketName").map(Output::outputValue).ifPresent(bucketName -> ToolkitStacks.cleanBucket(S3Client.create(), bucketName));
        return Stacks.deleteStack((CloudFormationClient)client, (String)stack.stackName());
    }

    private static void cleanBucket(S3Client client, String bucketName) {
        ListObjectVersionsRequest listObjectVersionsRequest = (ListObjectVersionsRequest)ListObjectVersionsRequest.builder().bucket(bucketName).build();
        Iterator objectVersionsIterator = client.listObjectVersionsPaginator(listObjectVersionsRequest).versions().iterator();
        while (objectVersionsIterator.hasNext()) {
            ArrayList<ObjectIdentifier> objectIdentifiers = new ArrayList<ObjectIdentifier>();
            while (objectVersionsIterator.hasNext() && objectIdentifiers.size() < 1000) {
                ObjectVersion objectVersion = (ObjectVersion)objectVersionsIterator.next();
                objectIdentifiers.add(ToolkitStacks.toObjectIdentifier(objectVersion));
            }
            DeleteObjectsRequest deleteRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucketName).delete((Delete)Delete.builder().objects(objectIdentifiers).build()).build();
            client.deleteObjects(deleteRequest);
        }
    }

    private static ObjectIdentifier toObjectIdentifier(ObjectVersion objectVersion) {
        return (ObjectIdentifier)ObjectIdentifier.builder().key(objectVersion.key()).versionId(objectVersion.versionId()).build();
    }
}

