/*
 * Decompiled with CFR 0.152.
 */
package io.datalbry.precise.serialization.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.datalbry.precise.api.schema.Schema;
import io.datalbry.precise.api.schema.field.Field;
import io.datalbry.precise.api.schema.type.EnumType;
import io.datalbry.precise.api.schema.type.RecordType;
import io.datalbry.precise.api.schema.type.Type;
import io.datalbry.precise.api.schema.type.Types;
import io.datalbry.precise.serialization.jackson.extension.JsonNodeExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lio/datalbry/precise/serialization/jackson/deserializer/SchemaDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lio/datalbry/precise/api/schema/Schema;", "()V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "toDocumentField", "Lio/datalbry/precise/api/schema/field/Field;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "toDocumentType", "Lio/datalbry/precise/api/schema/type/Type;", "toEnumType", "toType", "serialization-jackson"})
public final class SchemaDeserializer
extends StdDeserializer<Schema> {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public Schema deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext ctxt) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
        Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        JsonNode jsonNode = node.get("types");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonNode, (String)"node.get(\"types\")");
        Iterable iterable = (Iterable)jsonNode;
        SchemaDeserializer schemaDeserializer = this;
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            JsonNode jsonNode2 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Type type = schemaDeserializer.toType((JsonNode)p1);
            collection.add(type);
        }
        Set types = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return new Schema(types);
    }

    private final Type toType(JsonNode node) {
        Type type;
        String string = node.get("type").asText();
        if (Intrinsics.areEqual((Object)string, (Object)Types.RECORD.name())) {
            type = this.toDocumentType(node);
        } else if (Intrinsics.areEqual((Object)string, (Object)Types.ENUM.name())) {
            type = this.toEnumType(node);
        } else {
            throw (Throwable)new IllegalArgumentException("Type may only be DOCUMENT or ENUM");
        }
        return type;
    }

    private final Type toDocumentType(JsonNode node) {
        String name = node.get("name").asText();
        Set fields2 = JsonNodeExtensionsKt.mapValues(node, "fields", (Function1)new Function1<JsonNode, Field>(this){

            @NotNull
            public final Field invoke(@NotNull JsonNode p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return SchemaDeserializer.access$toDocumentField((SchemaDeserializer)((Object)this.receiver), p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SchemaDeserializer.class);
            }

            public final String getName() {
                return "toDocumentField";
            }

            public final String getSignature() {
                return "toDocumentField(Lcom/fasterxml/jackson/databind/JsonNode;)Lio/datalbry/precise/api/schema/field/Field;";
            }
        });
        String string = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        return (Type)new RecordType(string, fields2);
    }

    private final Field toDocumentField(JsonNode node) {
        String name = node.get("name").asText();
        String type = node.get("type").asText();
        boolean multiValue = node.get("multiValue").asBoolean();
        boolean optional = node.get("optional").asBoolean();
        String string = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        String string2 = type;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"type");
        return new Field(string, string2, multiValue, optional);
    }

    private final Type toEnumType(JsonNode node) {
        String name = node.get("name").asText();
        List list = node.findValuesAsText("values");
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"node.findValuesAsText(\"values\")");
        Set values = CollectionsKt.toSet((Iterable)list);
        String string = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        return (Type)new EnumType(string, values);
    }

    public SchemaDeserializer() {
        super(Schema.class);
    }

    public static final /* synthetic */ Field access$toDocumentField(SchemaDeserializer $this, JsonNode node) {
        return $this.toDocumentField(node);
    }
}

