/*
 * Decompiled with CFR 0.152.
 */
package io.datalbry.precise.serialization.jackson.deserializer;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdNodeBasedDeserializer;
import io.datalbry.precise.api.schema.Schema;
import io.datalbry.precise.api.schema.document.Field;
import io.datalbry.precise.api.schema.document.Record;
import io.datalbry.precise.api.schema.document.generic.GenericField;
import io.datalbry.precise.api.schema.document.generic.GenericRecord;
import io.datalbry.precise.api.schema.field.BasicFieldType;
import io.datalbry.precise.api.schema.type.RecordType;
import io.datalbry.precise.api.schema.type.Type;
import io.datalbry.precise.serialization.jackson.deserializer.GenericRecordDeserializer$WhenMappings;
import io.datalbry.precise.serialization.jackson.exception.InvalidTypeException;
import io.datalbry.precise.serialization.jackson.exception.NoSuchTypeException;
import io.datalbry.precise.serialization.jackson.extension.BasicFieldTypeExtensionsKt;
import io.datalbry.precise.serialization.jackson.extension.DocumentTypeExtensionsKt;
import io.datalbry.precise.serialization.jackson.extension.JsonNodeExtensionsKt;
import io.datalbry.precise.serialization.jackson.extension.SchemaExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0\u0010H\u0002J \u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0\u0010H\u0002J*\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u00152\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002J0\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0\u0010H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/datalbry/precise/serialization/jackson/deserializer/GenericRecordDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdNodeBasedDeserializer;", "Lio/datalbry/precise/api/schema/document/Record;", "schema", "Lio/datalbry/precise/api/schema/Schema;", "(Lio/datalbry/precise/api/schema/Schema;)V", "convert", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "getBasicField", "Lio/datalbry/precise/api/schema/document/Field;", "fieldSchema", "Lio/datalbry/precise/api/schema/field/Field;", "entry", "", "", "getEnumField", "Lio/datalbry/precise/api/schema/document/generic/GenericField;", "getFields", "", "typeSchema", "Lio/datalbry/precise/api/schema/type/RecordType;", "getRecordField", "type", "readValue", "", "Lio/datalbry/precise/api/schema/field/BasicFieldType;", "serialization-jackson"})
public final class GenericRecordDeserializer
extends StdNodeBasedDeserializer<Record> {
    private final Schema schema;

    @NotNull
    public Record convert(@NotNull JsonNode node, @NotNull DeserializationContext ctxt) {
        String type;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
        String string = type = node.get("type").asText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type");
        Type typeSchema = SchemaExtensionsKt.typeSchema(this.schema, string);
        if (!(typeSchema instanceof RecordType)) {
            throw (Throwable)new InvalidTypeException(typeSchema, RecordType.class);
        }
        RecordType recordType = (RecordType)typeSchema;
        JsonNode jsonNode = node.get("fields");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonNode, (String)"node.get(\"fields\")");
        Set<Field<?>> fields2 = this.getFields(this.schema, recordType, jsonNode);
        return (Record)new GenericRecord(type, fields2);
    }

    private final Set<Field<?>> getFields(Schema schema, RecordType typeSchema, JsonNode node) {
        Iterator iterator = node.fields();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"node.fields()");
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)new Function1<Map.Entry<String, JsonNode>, Field<?>>(this, typeSchema, schema){
            final /* synthetic */ GenericRecordDeserializer this$0;
            final /* synthetic */ RecordType $typeSchema;
            final /* synthetic */ Schema $schema;

            @NotNull
            public final Field<?> invoke(Map.Entry<String, JsonNode> it) {
                Field field;
                String string = it.getKey();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.key");
                io.datalbry.precise.api.schema.field.Field fieldSchema = DocumentTypeExtensionsKt.getFieldSchema(this.$typeSchema, string);
                String type = fieldSchema.getType();
                if (BasicFieldTypeExtensionsKt.isBasicFieldType(type)) {
                    Map.Entry<String, JsonNode> entry = it;
                    Intrinsics.checkExpressionValueIsNotNull(entry, (String)"it");
                    field = GenericRecordDeserializer.access$getBasicField(this.this$0, fieldSchema, entry);
                } else if (SchemaExtensionsKt.isEnumType(this.$schema, type)) {
                    Map.Entry<String, JsonNode> entry = it;
                    Intrinsics.checkExpressionValueIsNotNull(entry, (String)"it");
                    field = (Field)GenericRecordDeserializer.access$getEnumField(this.this$0, entry);
                } else if (SchemaExtensionsKt.isRecordType(this.$schema, type)) {
                    Map.Entry<String, JsonNode> entry = it;
                    Intrinsics.checkExpressionValueIsNotNull(entry, (String)"it");
                    field = GenericRecordDeserializer.access$getRecordField(this.this$0, this.$schema, fieldSchema, entry);
                } else {
                    throw (Throwable)new NoSuchTypeException(this.$schema, type);
                }
                return field;
            }
            {
                this.this$0 = genericRecordDeserializer;
                this.$typeSchema = recordType;
                this.$schema = schema;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Field<?> getRecordField(Schema schema, io.datalbry.precise.api.schema.field.Field type, Map.Entry<String, ? extends JsonNode> entry) {
        Object object;
        RecordType recordType = SchemaExtensionsKt.getRecordType(schema, type.getType());
        if (type.getMultiValue()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = JsonNodeExtensionsKt.mapValues(entry.getValue(), (Function1)new Function1<JsonNode, Set<? extends Field<?>>>(this, schema, recordType){
                final /* synthetic */ GenericRecordDeserializer this$0;
                final /* synthetic */ Schema $schema;
                final /* synthetic */ RecordType $recordType;

                @NotNull
                public final Set<Field<?>> invoke(@NotNull JsonNode it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return GenericRecordDeserializer.access$getFields(this.this$0, this.$schema, this.$recordType, it);
                }
                {
                    this.this$0 = genericRecordDeserializer;
                    this.$schema = schema;
                    this.$recordType = recordType;
                    super(1);
                }
            });
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Set set = (Set)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GenericRecord genericRecord = new GenericRecord(type.getType(), (Set)it);
                collection.add(genericRecord);
            }
            object = (List)destination$iv$iv;
        } else {
            object = new GenericRecord(type.getType(), this.getFields(schema, recordType, entry.getValue()));
        }
        GenericRecord records2 = object;
        return (Field)new GenericField(entry.getKey(), (Object)records2);
    }

    private final GenericField<?> getEnumField(Map.Entry<String, ? extends JsonNode> entry) {
        return new GenericField(entry.getKey(), (Object)entry.getValue().asText());
    }

    private final Field<?> getBasicField(io.datalbry.precise.api.schema.field.Field fieldSchema, Map.Entry<String, ? extends JsonNode> entry) {
        Set value2;
        BasicFieldType type = BasicFieldTypeExtensionsKt.basicFieldTypeById(fieldSchema.getType());
        JsonNode node = entry.getValue();
        Set set = value2 = fieldSchema.getMultiValue() ? JsonNodeExtensionsKt.mapValues(node, (Function1)new Function1<JsonNode, Object>(this, type, node){
            final /* synthetic */ GenericRecordDeserializer this$0;
            final /* synthetic */ BasicFieldType $type;
            final /* synthetic */ JsonNode $node;

            @Nullable
            public final Object invoke(@NotNull JsonNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return GenericRecordDeserializer.access$readValue(this.this$0, this.$type, this.$node);
            }
            {
                this.this$0 = genericRecordDeserializer;
                this.$type = basicFieldType;
                this.$node = jsonNode;
                super(1);
            }
        }) : this.readValue(type, node);
        if (set == null) {
            Intrinsics.throwNpe();
        }
        return (Field)new GenericField(entry.getKey(), set);
    }

    private final Object readValue(BasicFieldType type, JsonNode node) {
        Comparable comparable;
        switch (GenericRecordDeserializer$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                comparable = Integer.valueOf(node.asInt());
                break;
            }
            case 2: {
                comparable = Long.valueOf(node.asLong());
                break;
            }
            case 3: {
                comparable = Float.valueOf(JsonNodeExtensionsKt.asFloat(node));
                break;
            }
            case 4: {
                comparable = Double.valueOf(node.asDouble());
                break;
            }
            case 5: {
                int n = node.asInt();
                boolean bl = false;
                comparable = UByte.box-impl((byte)UByte.constructor-impl((byte)((byte)n)));
                break;
            }
            case 6: {
                comparable = (Comparable)((Object)node.asText());
                break;
            }
            case 7: {
                comparable = Boolean.valueOf(node.asBoolean());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return comparable;
    }

    public GenericRecordDeserializer(@NotNull Schema schema) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        super(Record.class);
        this.schema = schema;
    }

    public static final /* synthetic */ Field access$getBasicField(GenericRecordDeserializer $this, io.datalbry.precise.api.schema.field.Field fieldSchema, Map.Entry entry) {
        return $this.getBasicField(fieldSchema, entry);
    }

    public static final /* synthetic */ GenericField access$getEnumField(GenericRecordDeserializer $this, Map.Entry entry) {
        return $this.getEnumField(entry);
    }

    public static final /* synthetic */ Field access$getRecordField(GenericRecordDeserializer $this, Schema schema, io.datalbry.precise.api.schema.field.Field type, Map.Entry entry) {
        return $this.getRecordField(schema, type, entry);
    }

    public static final /* synthetic */ Set access$getFields(GenericRecordDeserializer $this, Schema schema, RecordType typeSchema, JsonNode node) {
        return $this.getFields(schema, typeSchema, node);
    }

    public static final /* synthetic */ Object access$readValue(GenericRecordDeserializer $this, BasicFieldType type, JsonNode node) {
        return $this.readValue(type, node);
    }
}

