/*
 * Decompiled with CFR 0.152.
 */
package io.datalbry.precise.serialization.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.datalbry.precise.api.schema.Schema;
import io.datalbry.precise.api.schema.document.Record;
import io.datalbry.precise.api.serialization.RecordDeserializer;
import io.datalbry.precise.serialization.jackson.PreciseModule;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lio/datalbry/precise/serialization/jackson/JacksonRecordDeserializer;", "Lio/datalbry/precise/api/serialization/RecordDeserializer;", "()V", "preconfiguredJackson", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "schema", "Lio/datalbry/precise/api/schema/Schema;", "read", "Lio/datalbry/precise/api/schema/document/Record;", "file", "Ljava/io/File;", "rawJson", "", "json", "", "serialization-jackson"})
public final class JacksonRecordDeserializer
implements RecordDeserializer {
    @NotNull
    public Record read(@NotNull Schema schema, @NotNull File file) {
        ObjectMapper jackson;
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ObjectMapper $this$readValue$iv = jackson = this.preconfiguredJackson(schema);
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        return (Record)$this$readValue$iv.readValue(file, (TypeReference)new TypeReference<Record>(){});
    }

    @NotNull
    public Record read(@NotNull Schema schema, @NotNull String json) {
        ObjectMapper jackson;
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        ObjectMapper $this$readValue$iv = jackson = this.preconfiguredJackson(schema);
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        return (Record)$this$readValue$iv.readValue(json, (TypeReference)new TypeReference<Record>(){});
    }

    @NotNull
    public Record read(@NotNull Schema schema, @NotNull byte[] rawJson) {
        ObjectMapper jackson;
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)rawJson, (String)"rawJson");
        ObjectMapper $this$readValue$iv = jackson = this.preconfiguredJackson(schema);
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        return (Record)$this$readValue$iv.readValue(rawJson, (TypeReference)new TypeReference<Record>(){});
    }

    private final ObjectMapper preconfiguredJackson(Schema schema) {
        ObjectMapper jackson = ExtensionsKt.jacksonObjectMapper();
        PreciseModule preciseModule = new PreciseModule(schema);
        ObjectMapper objectMapper = jackson.registerModule((Module)preciseModule);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"jackson.registerModule(preciseModule)");
        return objectMapper;
    }
}

