/*
 * Decompiled with CFR 0.152.
 */
package io.datalbry.precise.validation;

import io.datalbry.precise.api.schema.Schema;
import io.datalbry.precise.api.schema.document.Document;
import io.datalbry.precise.api.schema.document.Field;
import io.datalbry.precise.api.schema.document.Record;
import io.datalbry.precise.api.schema.type.RecordType;
import io.datalbry.precise.api.serialization.DocumentDeserializer;
import io.datalbry.precise.api.validation.DocumentValidator;
import io.datalbry.precise.validation.extensions.BasicFieldTypeExtensionsKt;
import io.datalbry.precise.validation.extensions.DocumentTypeExtensionsKt;
import io.datalbry.precise.validation.extensions.SchemaExtensionsKt;
import io.datalbry.precise.validation.util.ValidationUtilKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000f2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J\"\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/datalbry/precise/validation/DocumentValidatorImpl;", "Lio/datalbry/precise/api/validation/DocumentValidator;", "deserializer", "Lio/datalbry/precise/api/serialization/DocumentDeserializer;", "(Lio/datalbry/precise/api/serialization/DocumentDeserializer;)V", "isValid", "", "schema", "Lio/datalbry/precise/api/schema/Schema;", "type", "Lio/datalbry/precise/api/schema/document/Document;", "file", "Ljava/io/File;", "noMissingFields", "typeDefinition", "Lio/datalbry/precise/api/schema/type/RecordType;", "record", "Lio/datalbry/precise/api/schema/document/Record;", "validateField", "typeSchema", "it", "Lio/datalbry/precise/api/schema/document/Field;", "validateMultiValue", "value", "", "fieldSchema", "Lio/datalbry/precise/api/schema/field/Field;", "validateRecord", "validateValue", "validation"})
public final class DocumentValidatorImpl
implements DocumentValidator {
    private final DocumentDeserializer deserializer;

    public boolean isValid(@NotNull Schema schema, @NotNull Document type) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return this.validateRecord(schema, SchemaExtensionsKt.getRecordType(schema, type.getType()), (Record)type);
    }

    public boolean isValid(@NotNull Schema schema, @NotNull File file) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            Document document = (Document)this.deserializer.read(schema, file);
            bl = this.isValid(schema, document);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean validateRecord(Schema schema, RecordType typeDefinition, Record record) {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = record.getFields();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Field field = (Field)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Boolean bl3 = this.validateField(typeDefinition, (Field<?>)it, schema);
                collection.add(bl3);
            }
            Iterable $this$all$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean it = (Boolean)element$iv;
                    boolean bl4 = false;
                    if (it) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        boolean validFieldTypes = bl;
        boolean noMissingFields = this.noMissingFields(typeDefinition, record);
        return validFieldTypes && noMissingFields;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean noMissingFields(RecordType typeDefinition, Record record) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        String string;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = record.getFields();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            string = ((Field)receiver).getName();
            collection.add(string);
        }
        List presentFields = (List)destination$iv$iv;
        Iterable $this$filterNot$iv = typeDefinition.getFields();
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            io.datalbry.precise.api.schema.field.Field it = (io.datalbry.precise.api.schema.field.Field)element$iv$iv;
            boolean bl = false;
            if (it.getOptional()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterNotTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            io.datalbry.precise.api.schema.field.Field it = (io.datalbry.precise.api.schema.field.Field)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            string = it.getName();
            collection.add(string);
        }
        List mandatoryFields = (List)destination$iv$iv2;
        return presentFields.containsAll(mandatoryFields);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validateField(RecordType typeSchema, Field<?> it, Schema schema) {
        boolean bl;
        io.datalbry.precise.api.schema.field.Field fieldSchema = DocumentTypeExtensionsKt.getFieldType(typeSchema, it.getName());
        Object value = it.getValue();
        if (fieldSchema.getMultiValue()) {
            bl = this.validateMultiValue(value, fieldSchema, schema);
            return bl;
        } else {
            if (fieldSchema.getOptional()) {
                if (!(value instanceof Collection)) return false;
                Iterable $this$all$iv = (Iterable)value;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    return true;
                }
                Iterator iterator = $this$all$iv.iterator();
                do {
                    Object element$iv;
                    if (!iterator.hasNext()) return true;
                    Object it2 = element$iv = iterator.next();
                    boolean bl2 = false;
                } while (this.validateValue(fieldSchema, value, schema));
                return false;
            }
            bl = this.validateValue(fieldSchema, value, schema);
        }
        return bl;
    }

    private final boolean validateMultiValue(Object value, io.datalbry.precise.api.schema.field.Field fieldSchema, Schema schema) {
        boolean bl;
        block8: {
            Object object = value;
            if (object instanceof Collection) {
                Iterable $this$all$iv = (Iterable)value;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = $this$all$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv;
                        Object it = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (this.validateValue(fieldSchema, it, schema)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            } else if (object instanceof Object[]) {
                Object[] $this$all$iv = (Object[])value;
                boolean $i$f$all = false;
                Object[] objectArray = $this$all$iv;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object element$iv;
                    Object it = element$iv = objectArray[i];
                    boolean bl3 = false;
                    if (this.validateValue(fieldSchema, it, schema)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean validateValue(io.datalbry.precise.api.schema.field.Field fieldSchema, Object value, Schema schema) {
        String type = fieldSchema.getType();
        return BasicFieldTypeExtensionsKt.isBasicFieldType(type) ? ValidationUtilKt.isValidBasicType(fieldSchema, value) : (SchemaExtensionsKt.isDefinedEnumType(schema, type) ? ValidationUtilKt.isValidEnum(SchemaExtensionsKt.getEnumType(schema, type), value) : (value instanceof Record ? this.validateRecord(schema, SchemaExtensionsKt.getRecordType(schema, type), (Record)value) : false));
    }

    public DocumentValidatorImpl(@NotNull DocumentDeserializer deserializer) {
        Intrinsics.checkParameterIsNotNull((Object)deserializer, (String)"deserializer");
        this.deserializer = deserializer;
    }
}

