/*
 * Decompiled with CFR 0.152.
 */
package io.datalbry.jira.cloud.client.feign.board;

import feign.FeignException;
import io.datalbry.jira.cloud.client.BoardClient;
import io.datalbry.jira.cloud.client.exception.UnsupportedBoardTypeException;
import io.datalbry.jira.cloud.client.feign.board.FeignBoardResource;
import io.datalbry.jira.cloud.client.feign.iterator.PaginatedIterator;
import io.datalbry.jira.cloud.client.model.Board;
import io.datalbry.jira.cloud.client.model.BoardKey;
import io.datalbry.jira.cloud.client.model.Configuration;
import io.datalbry.jira.cloud.client.model.Features;
import io.datalbry.jira.cloud.client.model.Issue;
import io.datalbry.jira.cloud.client.model.IssueKey;
import io.datalbry.jira.cloud.client.model.Project;
import io.datalbry.jira.cloud.client.model.Quickfilter;
import io.datalbry.jira.cloud.client.model.QuickfilterKey;
import io.datalbry.jira.cloud.client.model.Reports;
import io.datalbry.jira.cloud.client.model.Sprint;
import io.datalbry.jira.cloud.client.model.SprintKey;
import io.datalbry.jira.cloud.client.model.Version;
import io.datalbry.jira.cloud.client.pagination.Paginated;
import io.datalbry.jira.cloud.client.pagination.PaginatedIssues;
import io.datalbry.jira.cloud.client.pagination.PaginatedValues;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/datalbry/jira/cloud/client/feign/board/FeignBoardClient;", "Lio/datalbry/jira/cloud/client/BoardClient;", "feignBoardResource", "Lio/datalbry/jira/cloud/client/feign/board/FeignBoardResource;", "(Lio/datalbry/jira/cloud/client/feign/board/FeignBoardResource;)V", "getBoard", "Lio/datalbry/jira/cloud/client/model/Board;", "boardKey", "Lio/datalbry/jira/cloud/client/model/BoardKey;", "getBoardKeys", "", "pageSize", "", "getConfiguration", "Lio/datalbry/jira/cloud/client/model/Configuration;", "getFeatures", "Lio/datalbry/jira/cloud/client/model/Features;", "getIssue", "Lio/datalbry/jira/cloud/client/model/Issue;", "issueKey", "Lio/datalbry/jira/cloud/client/model/IssueKey;", "getIssueKeys", "getProjects", "Lio/datalbry/jira/cloud/client/model/Project;", "getQuickfilter", "Lio/datalbry/jira/cloud/client/model/Quickfilter;", "quickfilterKey", "Lio/datalbry/jira/cloud/client/model/QuickfilterKey;", "getQuickfilterKeys", "getReports", "Lio/datalbry/jira/cloud/client/model/Reports;", "getSprint", "Lio/datalbry/jira/cloud/client/model/Sprint;", "sprintKey", "Lio/datalbry/jira/cloud/client/model/SprintKey;", "getSprintKeys", "getVersions", "Lio/datalbry/jira/cloud/client/model/Version;", "client"})
public final class FeignBoardClient
implements BoardClient {
    private final FeignBoardResource feignBoardResource;

    @NotNull
    public Iterator<BoardKey> getBoardKeys(int pageSize) {
        int n = pageSize;
        int n2 = 0;
        PaginatedValues<BoardKey> page = this.feignBoardResource.getBoardKeys(n, n2);
        return new PaginatedIterator((Paginated)page, (Function1)new Function1<Paginated<BoardKey>, Paginated<BoardKey>>(this, pageSize){
            final /* synthetic */ FeignBoardClient this$0;
            final /* synthetic */ int $pageSize;

            @NotNull
            public final Paginated<BoardKey> invoke(@NotNull Paginated<BoardKey> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (Paginated)FeignBoardClient.access$getFeignBoardResource$p(this.this$0).getBoardKeys(this.$pageSize, it.getStart() + it.getMaxResults());
            }
            {
                this.this$0 = feignBoardClient;
                this.$pageSize = n;
                super(1);
            }
        });
    }

    @NotNull
    public Board getBoard(@NotNull BoardKey boardKey) {
        Intrinsics.checkNotNullParameter((Object)boardKey, (String)"boardKey");
        return this.feignBoardResource.getBoard(boardKey.getId());
    }

    @NotNull
    public Configuration getConfiguration(@NotNull BoardKey boardKey) {
        Intrinsics.checkNotNullParameter((Object)boardKey, (String)"boardKey");
        return this.feignBoardResource.getConfiguration(boardKey.getId());
    }

    @NotNull
    public Iterator<IssueKey> getIssueKeys(@NotNull BoardKey boardKey, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)boardKey, (String)"boardKey");
        int n = pageSize;
        int n2 = 0;
        PaginatedIssues<IssueKey> page = this.feignBoardResource.getIssueKeys(boardKey.getId(), n, n2);
        return new PaginatedIterator((Paginated)page, (Function1)new Function1<Paginated<IssueKey>, Paginated<IssueKey>>(this, boardKey, pageSize){
            final /* synthetic */ FeignBoardClient this$0;
            final /* synthetic */ BoardKey $boardKey;
            final /* synthetic */ int $pageSize;

            @NotNull
            public final Paginated<IssueKey> invoke(@NotNull Paginated<IssueKey> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (Paginated)FeignBoardClient.access$getFeignBoardResource$p(this.this$0).getIssueKeys(this.$boardKey.getId(), this.$pageSize, it.getStart() + it.getMaxResults());
            }
            {
                this.this$0 = feignBoardClient;
                this.$boardKey = boardKey;
                this.$pageSize = n;
                super(1);
            }
        });
    }

    @NotNull
    public Issue getIssue(@NotNull IssueKey issueKey) {
        Intrinsics.checkNotNullParameter((Object)issueKey, (String)"issueKey");
        return this.feignBoardResource.getIssue(issueKey.getId());
    }

    @NotNull
    public Features getFeatures(@NotNull BoardKey boardKey) {
        Features features;
        Intrinsics.checkNotNullParameter((Object)boardKey, (String)"boardKey");
        try {
            features = this.feignBoardResource.getFeatures(boardKey.getId());
        }
        catch (FeignException.BadRequest e) {
            throw (Throwable)new UnsupportedBoardTypeException(boardKey);
        }
        return features;
    }

    @NotNull
    public Iterator<QuickfilterKey> getQuickfilterKeys(@NotNull BoardKey boardKey, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)boardKey, (String)"boardKey");
        int n = pageSize;
        int n2 = 0;
        PaginatedValues<QuickfilterKey> page = this.feignBoardResource.getQuickfilterKeys(boardKey.getId(), n, n2);
        return new PaginatedIterator((Paginated)page, (Function1)new Function1<Paginated<QuickfilterKey>, Paginated<QuickfilterKey>>(this, boardKey, pageSize){
            final /* synthetic */ FeignBoardClient this$0;
            final /* synthetic */ BoardKey $boardKey;
            final /* synthetic */ int $pageSize;

            @NotNull
            public final Paginated<QuickfilterKey> invoke(@NotNull Paginated<QuickfilterKey> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (Paginated)FeignBoardClient.access$getFeignBoardResource$p(this.this$0).getQuickfilterKeys(this.$boardKey.getId(), this.$pageSize, it.getStart() + it.getMaxResults());
            }
            {
                this.this$0 = feignBoardClient;
                this.$boardKey = boardKey;
                this.$pageSize = n;
                super(1);
            }
        });
    }

    @NotNull
    public Quickfilter getQuickfilter(@NotNull QuickfilterKey quickfilterKey) {
        Intrinsics.checkNotNullParameter((Object)quickfilterKey, (String)"quickfilterKey");
        return this.feignBoardResource.getQuickfilter(quickfilterKey.getBoardId(), quickfilterKey.getId());
    }

    @NotNull
    public Iterator<Version> getVersions(@NotNull BoardKey boardKey, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)boardKey, (String)"boardKey");
        int n = pageSize;
        int n2 = 0;
        PaginatedValues<Version> page = this.feignBoardResource.getVersions(boardKey.getId(), n, n2);
        return new PaginatedIterator((Paginated)page, (Function1)new Function1<Paginated<Version>, Paginated<Version>>(this, boardKey, pageSize){
            final /* synthetic */ FeignBoardClient this$0;
            final /* synthetic */ BoardKey $boardKey;
            final /* synthetic */ int $pageSize;

            @NotNull
            public final Paginated<Version> invoke(@NotNull Paginated<Version> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (Paginated)FeignBoardClient.access$getFeignBoardResource$p(this.this$0).getVersions(this.$boardKey.getId(), this.$pageSize, it.getStart() + it.getMaxResults());
            }
            {
                this.this$0 = feignBoardClient;
                this.$boardKey = boardKey;
                this.$pageSize = n;
                super(1);
            }
        });
    }

    @NotNull
    public Reports getReports(@NotNull BoardKey boardKey) {
        Intrinsics.checkNotNullParameter((Object)boardKey, (String)"boardKey");
        try {
            return this.feignBoardResource.getReports(boardKey.getId());
        }
        catch (FeignException.BadRequest e) {
            throw (Throwable)new UnsupportedBoardTypeException(boardKey);
        }
    }

    @NotNull
    public Iterator<SprintKey> getSprintKeys(@NotNull BoardKey boardKey, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)boardKey, (String)"boardKey");
        try {
            int n = pageSize;
            int n2 = 0;
            PaginatedValues<SprintKey> page = this.feignBoardResource.getSprintsKeys(boardKey.getId(), n, n2);
            return new PaginatedIterator((Paginated)page, (Function1)new Function1<Paginated<SprintKey>, Paginated<SprintKey>>(this, boardKey, pageSize){
                final /* synthetic */ FeignBoardClient this$0;
                final /* synthetic */ BoardKey $boardKey;
                final /* synthetic */ int $pageSize;

                @NotNull
                public final Paginated<SprintKey> invoke(@NotNull Paginated<SprintKey> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return (Paginated)FeignBoardClient.access$getFeignBoardResource$p(this.this$0).getSprintsKeys(this.$boardKey.getId(), this.$pageSize, it.getStart() + it.getMaxResults());
                }
                {
                    this.this$0 = feignBoardClient;
                    this.$boardKey = boardKey;
                    this.$pageSize = n;
                    super(1);
                }
            });
        }
        catch (FeignException.BadRequest e) {
            throw (Throwable)new UnsupportedBoardTypeException(boardKey);
        }
    }

    @NotNull
    public Sprint getSprint(@NotNull SprintKey sprintKey) {
        Intrinsics.checkNotNullParameter((Object)sprintKey, (String)"sprintKey");
        return this.feignBoardResource.getSprint(sprintKey.getId());
    }

    @NotNull
    public Iterator<Project> getProjects(@NotNull BoardKey boardKey, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)boardKey, (String)"boardKey");
        int n = pageSize;
        int n2 = 0;
        PaginatedValues<Project> page = this.feignBoardResource.getProjects(boardKey.getId(), n, n2);
        return new PaginatedIterator((Paginated)page, (Function1)new Function1<Paginated<Project>, Paginated<Project>>(this, boardKey, pageSize){
            final /* synthetic */ FeignBoardClient this$0;
            final /* synthetic */ BoardKey $boardKey;
            final /* synthetic */ int $pageSize;

            @NotNull
            public final Paginated<Project> invoke(@NotNull Paginated<Project> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (Paginated)FeignBoardClient.access$getFeignBoardResource$p(this.this$0).getProjects(this.$boardKey.getId(), this.$pageSize, it.getStart() + it.getMaxResults());
            }
            {
                this.this$0 = feignBoardClient;
                this.$boardKey = boardKey;
                this.$pageSize = n;
                super(1);
            }
        });
    }

    public FeignBoardClient(@NotNull FeignBoardResource feignBoardResource) {
        Intrinsics.checkNotNullParameter((Object)feignBoardResource, (String)"feignBoardResource");
        this.feignBoardResource = feignBoardResource;
    }

    public static final /* synthetic */ FeignBoardResource access$getFeignBoardResource$p(FeignBoardClient $this) {
        return $this.feignBoardResource;
    }
}

