package io.datalbry.jira.cloud.client.feign.iterator

import io.datalbry.jira.cloud.client.pagination.Paginated

class PaginatedIterator<Resource>(
    page: Paginated<Resource>,
    val fetchNext: (Paginated<Resource>) -> Paginated<Resource>
)
    : Iterator<Resource>
{
    private var currentPage = page
    private var currentIter = page.getElements().iterator()

    override fun hasNext(): Boolean {
        if (!currentIter.hasNext()) {
            currentPage = fetchNext(currentPage)
            currentIter = currentPage.getElements().iterator()
            return currentIter.hasNext()
        }
        return true
    }

    override fun next(): Resource {
        return currentIter.next()
    }
}