package io.datalbry.jira.cloud.client.feign.extensions

import com.fasterxml.jackson.databind.DeserializationFeature
import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.databind.SerializationFeature
import com.fasterxml.jackson.databind.module.SimpleModule
import com.fasterxml.jackson.databind.util.StdDateFormat
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer
import com.fasterxml.jackson.module.kotlin.jacksonObjectMapper
import java.time.LocalDate
import java.time.LocalDateTime
import java.time.format.DateTimeFormatter


/**
 * Static function to create a Jackson [ObjectMapper] preconfigured
 * with JDK8Module, to provide Optional handling, as well as disabling FAIL_ON_UNKNOWN_PROPERTIES
 *
 * @return newly created [ObjectMapper]
 *
 * @author timo gruen - 2021-01-06
 */
fun jackson(): ObjectMapper {
    val mapper = jacksonObjectMapper()
    mapper.registerModule(Jdk8Module())
    mapper.registerModule(JavaTimeModule())
    mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)
    mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING)
    mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)

    val datetimePattern = DateTimeFormatter.ofPattern("yyyy-MM-dd\'T\'HH:mm:ss.SSS[VV][Z]")
    val localDateTimeModule = SimpleModule();
    localDateTimeModule.addDeserializer(LocalDateTime::class.java, LocalDateTimeDeserializer(datetimePattern))

    mapper.registerModules(localDateTimeModule);

    return mapper
}
